/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.search;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CQLComposer {
    protected String queryString;
    protected BrikitList<String> labels;
    protected BrikitList<String> searchScope;
    protected BrikitList<String> spaceSearchScope;
    protected BrikitList<String> contentTypes;
    protected String created;
    protected String lastModified;
    protected String sortBy;

    public String contentTypeClause() {
        return this.getContentTypes().isEmpty() ? null : "type in (" + this.quotedJoinedValues(this.getContentTypes()) + ")";
    }

    public String cql() {
        BrikitList<String> andClauses = new BrikitList<String>();
        andClauses.add(this.contentTypeClause());
        andClauses.add(this.queryStringClause());
        andClauses.add(this.labelClause());
        andClauses.add(this.spaceKeyClause());
        andClauses.add(this.lastModifiedClause());
        andClauses.compact();
        String orderClause = BrikitString.isSet(this.getSortBy()) ? " " + this.getSortBy() : "";
        return andClauses.join(" and ") + orderClause;
    }

    public BrikitList<String> getCombinedSpaceKeys() {
        HashSet<String> keySet = new HashSet<String>();
        BrikitList<String> spaceScope = new BrikitList<String>((List<String>)this.getSpaceSearchScope());
        for (String key : spaceScope) {
            keySet.add("@current".equals(key) ? "currentSpace()" : key);
        }
        if (!this.getSearchScope().isEmpty()) {
            keySet.addAll(Confluence.spaceKeysWithLabels(this.getSearchScope(), true));
        }
        BrikitList<String> keys = new BrikitList<String>((Set<String>)keySet);
        keys.compact();
        return keys;
    }

    public BrikitList<String> getContentTypes() {
        if (this.contentTypes == null) {
            this.contentTypes = new BrikitList();
        }
        return this.contentTypes;
    }

    public String getCreated() {
        return this.created;
    }

    public BrikitList<String> getLabels() {
        if (this.labels == null) {
            this.labels = new BrikitList();
        }
        return this.labels;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public BrikitList<String> getSearchScope() {
        if (this.searchScope == null) {
            this.searchScope = new BrikitList();
        }
        return this.searchScope;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public BrikitList<String> getSpaceSearchScope() {
        if (this.spaceSearchScope == null) {
            this.spaceSearchScope = new BrikitList();
        }
        return this.spaceSearchScope;
    }

    public String labelClause() {
        return this.getLabels().isEmpty() ? null : "label in (" + this.quotedJoinedValues(this.getLabels()) + ")";
    }

    public String createdClause() {
        if (!BrikitString.isSet(this.getCreated())) {
            return null;
        }
        if ("LASTDAY".equals(this.getCreated())) {
            return "created >= now('-1d')";
        }
        if ("LASTTWODAYS".equals(this.getCreated())) {
            return "created >= now('-2d')";
        }
        if ("LASTWEEK".equals(this.getCreated())) {
            return "created >= now('-1w')";
        }
        if ("LASTMONTH".equals(this.getCreated())) {
            return "created >= now('-1M')";
        }
        if ("LASTSIXMONTHS".equals(this.getCreated())) {
            return "created >= now('-6M')";
        }
        if ("LASTYEAR".equals(this.getCreated())) {
            return "created >= now('-1y')";
        }
        if ("LASTTWOYEARS".equals(this.getCreated())) {
            return "created >= now('-2y')";
        }
        return "created " + this.getCreated();
    }

    public String lastModifiedClause() {
        if (!BrikitString.isSet(this.getLastModified())) {
            return null;
        }
        if ("LASTDAY".equals(this.getLastModified())) {
            return "lastmodified >= now('-1d')";
        }
        if ("LASTTWODAYS".equals(this.getLastModified())) {
            return "lastmodified >= now('-2d')";
        }
        if ("LASTWEEK".equals(this.getLastModified())) {
            return "lastmodified >= now('-1w')";
        }
        if ("LASTMONTH".equals(this.getLastModified())) {
            return "lastmodified >= now('-1M')";
        }
        if ("LASTSIXMONTHS".equals(this.getLastModified())) {
            return "lastmodified >= now('-6M')";
        }
        if ("LASTYEAR".equals(this.getLastModified())) {
            return "lastmodified >= now('-1y')";
        }
        if ("LASTTWOYEARS".equals(this.getLastModified())) {
            return "lastmodified >= now('-2y')";
        }
        return "lastmodified " + this.getLastModified();
    }

    public String queryStringClause() {
        return BrikitString.isSet(this.getQueryString()) ? "siteSearch ~ \"" + this.getQueryString().replaceAll("\"", "\\\"") + "\"" : null;
    }

    public String quotedJoinedValues(BrikitList<String> values) {
        BrikitList<String> quoted = new BrikitList<String>();
        for (String value : values) {
            if ((value = BrikitString.trimToNull(value)) == null) continue;
            quoted.add('\"' + value + '\"');
        }
        return quoted.join(",");
    }

    public void setContentTypes(List<String> contentTypes) {
        this.contentTypes = contentTypes instanceof BrikitList ? (BrikitList<Object>)contentTypes : new BrikitList<String>(contentTypes);
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels instanceof BrikitList ? (BrikitList<Object>)labels : new BrikitList<String>(labels);
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setSearchScope(List<String> searchScope) {
        this.searchScope = searchScope instanceof BrikitList ? (BrikitList<Object>)searchScope : new BrikitList<String>(searchScope);
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSpaceSearchScope(String spaceKey) {
        BrikitList<String> scope = new BrikitList<String>();
        scope.add(spaceKey);
        this.setSpaceSearchScope(scope);
    }

    public void setSpaceSearchScope(List<String> spaceSearchScope) {
        this.spaceSearchScope = new BrikitList<String>(spaceSearchScope);
    }

    public String spaceKeyClause() {
        BrikitList<String> keys = this.getCombinedSpaceKeys();
        return keys.isEmpty() ? null : "space in (" + this.quotedJoinedValues(keys) + ")";
    }
}

