(function ($) { 

	TargetedSearch.FilterResultsField = function (element) {
		this.element = $(element);
		this.field = this.element.find("input");
		this.initialize();
	};
	
	Object.assign(TargetedSearch.FilterResultsField.prototype, {

		filterResults: function (e) {
			e.preventDefault();
			
			var filter = this.field.val().toLowerCase();
			
			this.results().each(function () {
				var match = $(".rich-link-title", this).text().toLowerCase().indexOf(filter) != -1 || 
					$(".rich-link-description", this).text().toLowerCase().indexOf(filter) != -1 ||
					$(".rich-link-excerpt", this).text().toLowerCase().indexOf(filter) != -1;
				$(this).showIf(match);
			});
			
			TargetedSearch.Labels.updateFilterGroupVisibility();
			
		},

		initialize: function () {
			this.field.on("keyup", this.filterResults.bind(this));
		},
		
		results: function () {
			return $(".rich-link-wrapper", ".content-query.display-rich-links");
		}
		
	});
			
	TargetedSearch.toInit(function ($) {
		$(".filter-results-field").each(function () { new TargetedSearch.FilterResultsField(this); });
	});

})(jQuery);
