(function ($) { 

	// Return the set of elements whose bottom edge is above the bottom of the window. If percentage is set, return the elements
	// whose bottom edge is percentage% up from the bottom of the window (i.e., if percentage is 30, include receivers in the 
	// top 70% of the window).
	$.fn.aboveTheFold = function(percentage, topOnly) {

        // Get the window scroll location and height
        var visibleWindowTop = $(window).scrollTop();
        var windowHeight = $(window).height();
		var fromBottom = typeof(percentage) == "undefined" ? 0 : windowHeight * percentage / 100;
        var visibleWindowBottom = visibleWindowTop + windowHeight - fromBottom;

		var justTop = typeof(topOnly) == "undefined" ? false : topOnly;
        return this.filter(function() {
			return $(this).offset().top + (justTop ? 0 : $(this).height()) <= visibleWindowBottom;
        });
	};

	// If shouldAdd, ensure receiver has the classNames, otherwise, do nothing
	$.fn.addClassIf = function(classNames, shouldAdd) {
        return this.each(function() {
			if (shouldAdd) $(this).addClass(classNames);
        });
	};

	// Add classNames to the receiver, or if the receiver is contained in containerSelector, add classNames to the container instead
	$.fn.addClassToElementOrContainer = function(classNames, containerSelector) {
        return this.each(function() {
			var $container = $(this).closest(containerSelector); 
			if ($container.length) $container.addClass(classNames);
			else $(this).addClass(classNames);
        });
	};

	// If shouldAdd, ensure receiver has the attribute and value, otherwise, ensure it doesn't have the attribute
	$.fn.adjustAttr = function(attribute, value, shouldAdd) {
        return this.each(function() {
			if (shouldAdd) $(this).attr(attribute, value);
			else $(this).removeAttr(attribute);
        });
	};

	// If shouldAdd, ensure receiver has the classNames, otherwise, ensure it doesn't
	$.fn.adjustClass = function(classNames, shouldAdd) {
        return this.each(function() {
			if (shouldAdd) $(this).addClass(classNames);
			else $(this).removeClass(classNames);
        });
	};

	// Make textareas auto-adjust to match input height
	$.fn.autoSizingTextarea = function() {
		var adjustHeight = function () {
			$(this).height(1);
			$(this).height(Math.max(28, $(this).height() + this.scrollHeight));
		};
		
        return this.each(function() {
			if (!$(this).hasClass("autosizing")) $(this).css({overflowY: "auto"}).addClass("autosizing").keyup(adjustHeight);
			adjustHeight.call(this);
        });
	};

	// Same as jQuery's click, but does nothing if the element has .disabled applied to itself or a parent element
	$.fn.clickIfNotDisabled = function(callback) {
        return this.each(function() {
			$(this).click(function () {
				return !$(this).hasClass("disabled") && !$(this).parents(".disabled").length && callback.call(this);
			});
        });
	};

    // Convert the data-copy-id attribute to a simple id
	$.fn.convertDataCopyIds = function() {
        return this.each(function() {
            $(this).attr("id", $(this).attr("data-copy-id")).removeAttr("data-copy-id");
        });
	};

	// If show is true, fade in the receiver, otherwise hide it. If speed isn't specified, use "fast" fade. Invoke callback after the animation finishes.
	$.fn.fadeInIf = function(show, speed, callback) {
		speed = typeof(speed) == "undefined" ? "fast" : speed;
        return this.each(function() {
			if (show) $(this).fadeIn(speed, callback);
			else $(this).fadeOut(speed, callback);
        });
	};

	// Return true if the receiver has attribute (matching value if provided). Return false if the receiver is empty.
	$.fn.hasAttr = function(attribute, value) {
		var result = this.length;
        this.each(function() {
			result = result && $(this).attr(attribute);
			if (typeof(value) != "undefined") result = result && $(this).attr(attribute) == value;
        });
		return result;
	};

	// Return true if the receiver contains an input or textarea with a value, or a checkbox checked, or a select field with a non-empty selection
	$.fn.hasValues = function() {
        return this.filter(function() { return $(this).attr("type") == "checkbox" ? $(this).attr("checked") : $(this).val(); }).length;
	};

	// If hide is true, hide the receiver, otherwise show it
	$.fn.hideIf = function(hide) {
        return this.showIf(!hide);
	};

	// Initialize the expanders
	$.fn.initializeExpander = function(callback) {
		return this.each(function() {
			var $expander = $(this);
			if ($expander.hasClass("initialized")) return;

			$expander.addClass("initialized");
			var $control = $expander.find(".brikit-expander-control");
			var $content = $expander.find(".brikit-expander-content").showIf($control.hasClass("expanded"));
			var $expanderIcon = $control.hasClass("expander-icon") ? $control : $control.find(".expander-icon");
			
			var useChevronIcons = $expanderIcon.attr("class") && $expanderIcon.attr("class").indexOf("chevron") != -1;
			var expandedIconClass = useChevronIcons ? "aui-iconfont-chevron-up" : "aui-iconfont-expanded";
			var collapsedIconClass = useChevronIcons ? "aui-iconfont-chevron-down" : "aui-iconfont-collapsed";

			var adjustVisibility = function () {
				var isExpanded = $control.hasClass("expanded");
				$expanderIcon.adjustClass(expandedIconClass, isExpanded);
				$expanderIcon.adjustClass(collapsedIconClass, !isExpanded);
                if (jQuery.browser.msie) $content.showIf(isExpanded);
                else $content.slideOpenIf(isExpanded, callback);
			}
			
			var toggle = function () {
				$control.toggleClass("expanded");
				adjustVisibility();
			}
			$control.click(toggle);
			if ($control.data("start-open")) $control.addClass("expanded");

			adjustVisibility();
        });
	};

	// Initialize group selectors
	$.fn.initializeGroupMultiSelect = function() {
        return this.each(function() {
			var $multiSelect = $(this);
			
			// Allow the groups choices to be removed
			$multiSelect.on("click", ".aui-icon-close", function (e) { 
				e.preventDefault();
				e.stopPropagation();
				var $button = $(this);
				var $removeGroup = $button.closest(".group-multi-select-choice");
				$button.spin();
				var groupData = $multiSelect.data("properties");
				groupData.group = $removeGroup.data("group");
				$.post($multiSelect.data("remove-url"), groupData, 
					function (data, textStatus, XMLHttpRequest, alertTitle) {
						if ($(data).hasClass("errorMessage")) {
							$button.spinStop();
							ThemePress.Dialog2.alert("<p>" + data + "</p>", { title: "Remove Access" });
						}
						else {
							$removeGroup.fadeOut(function () { $removeGroup.remove(); });
						}
					}
				);
			});
			
			// 
			$(".group-multi-select-search-field", $multiSelect)
				.bind("selected.autocomplete-user-or-group", function (event, data) {
					event.preventDefault();
					
					$accessGroups = $(".selected-groups", $multiSelect);
					$accessGroups.spin();
					$(this).val("");
					
					var groupData = $multiSelect.data("properties");
					groupData.group = data.content.key;
					$.post($multiSelect.data("add-url"), groupData, 
						function (data, textStatus, XMLHttpRequest, alertTitle) {
							if ($(data).hasClass("errorMessage")) {
								$accessGroups.spinStop();
								ThemePress.Dialog2.alert("<p>" + data + "</p>", { title: "Add Access" });
							}
							else {
								var $newGroup = $("<span>").addClass("group-multi-select-choice aui-label aui-label-closeable")
									.attr("data-group", groupData.group)
									.text(groupData.group)
									.append($("<span>").addClass("aui-icon aui-icon-close"));
								$accessGroups.spinStop().append($newGroup);
								$newGroup.hide().fadeIn(function () { $newGroup.css({display: "inline-block" }); });
							}
						}
					);
				})
				.bind("open.autocomplete-user-or-group", function (event, data) {
					$(this).closest(".group-multi-select").find(".autocomplete ol li").each(function () {
						var groupName = $(this).data("properties").name;
						if ($multiSelect.find(".group-multi-select-choice[data-group='" + groupName + "']").length) $(this).remove();
					})
				});

			Confluence.Binder.autocompleteUserOrGroup();
			
        });
	};

	// Initialize group selectors
	$.fn.initializeSpaceCategoryMultiSelect = function() {
        return this.each(function() {
			var $multiSelect = $(this);
			var $multiSelectField = $multiSelect.find(".category-multi-select-search-field");
						
			// Allow the space category choices to be removed
			$multiSelect.on("click", ".aui-icon-close", function (e) { 
				e.preventDefault();
				e.stopPropagation();
				var $button = $(this);
				var $removeCategory = $button.closest(".category-multi-select-choice");
				$button.spin();
				var categoryData = $multiSelect.data("properties");
				categoryData.category = $removeCategory.data("category");
				$.post($multiSelect.data("remove-url"), categoryData, 
					function (data, textStatus, XMLHttpRequest, alertTitle) {
						if ($(data).hasClass("errorMessage")) {
							$button.spinStop();
							ThemePress.Dialog2.alert("<p>" + data + "</p>", { title: "Remove Category" });
						}
						else {
							var $option = $("<option>").text(categoryData.category).attr("data-category", categoryData.category);
							var $lower = $multiSelectField.find("option").filter(function () { return $(this).data("category") < categoryData.category; }).last();
							// if (!$lower.length) $lower = $multiSelectField.find("option").first();
							$lower.after($option);
							$removeCategory.fadeOut(function () { $removeCategory.remove(); });
						}
					}
				);
			});
			
			// 
			$multiSelectField
				.auiSelect2()
				.change(function (event) {
					event.preventDefault();
					if (!$multiSelectField.val()) return;
					
					$selectedCategories = $(".selected-categories", $multiSelect);
					$selectedCategories.spin();
					
					var categoryData = $multiSelect.data("properties");
					categoryData.category = $multiSelectField.val();
					$.post($multiSelect.data("add-url"), categoryData, 
						function (data, textStatus, XMLHttpRequest, alertTitle) {
							if ($(data).hasClass("errorMessage")) {
								$selectedCategories.spinStop();
								ThemePress.Dialog2.alert("<p>" + data + "</p>", { title: "Add Category" });
							}
							else {
								var $newCategory = $("<span>").addClass("category-multi-select-choice aui-label aui-label-closeable")
									.attr("data-category", categoryData.category)
									.text(categoryData.category)
									.append($("<span>").addClass("aui-icon aui-icon-close"));
								$selectedCategories.spinStop().append($newCategory);
								$multiSelectField.val(null).trigger("change")
									.find("option[data-category='" + categoryData.category + "']").remove();
								$newCategory.hide().fadeIn(function () { $newCategory.css({display: "inline-block" }); });
							}
						}
					);
				})
				.bind("open.autocomplete-user-or-category", function (event, data) {
					$(this).closest(".category-select").find(".autocomplete ol li").each(function () {
						var categoryName = $(this).data("properties").name;
						if ($multiSelect.find(".category-multi-select-choice[data-category='" + cateboryName + "']").length) $(this).remove();
					})
				});
			
        });
	};

	// Return true if the bottom edge of all of the receivers are above the bottom of the window. If any is true, return true if any
	// of the the receivers are above the fold.
	$.fn.isAboveTheFold = function(any) {

        // Get the window scroll location and height
        var visibleWindowTop = $((jQuery.browser.mozilla || jQuery.browser.msie)? "html" : "body").scrollTop();
        var windowHeight = $(window).height();
        var visibleWindowBottom = visibleWindowTop + windowHeight;

		if (typeof(any) == "undefined") any = false;
		var aboveTheFold = !any;
        this.each(function() {
			var elementBottom = $(this).offset().top + $(this).height();
            var above = elementBottom <= visibleWindowBottom;
			if (any) {
				if (above) aboveTheFold = true;
			}
			else {
				if (!above) aboveTheFold = false;
			}
        });

		return aboveTheFold;
	};

	// Return true if any elements are not visible or if no elements in list. If all is true, return true if all elements are not visible
	$.fn.isHidden = function(all) {
		var hidden = !this.length || all;
        this.each(function() {
			if (all) hidden = hidden && ($(this).hasClass("hidden") || $(this).css("display") == "none");
			else hidden = hidden || $(this).hasClass("hidden") || $(this).css("display") == "none";
        });
		return hidden;
	};

	// Return true if all elements are visible (if no elements in list, return false)
	$.fn.isShowing = function() {
		return !this.isHidden();
	};

	// Return true if the first element is completely visible within the window
	$.fn.isVisibleToUser = function(scroller) {
		
		scroller = scroller || window;

        // Get the window scroll location and height
        var visibleWindowTop = $((jQuery.browser.mozilla || jQuery.browser.msie)? "html" : "body").scrollTop();
        var windowHeight = $(scroller).height();
        var visibleWindowBottom = visibleWindowTop + windowHeight;

		var visible = false;
        this.first().each(function() {
			var elementTop = $(this).offset().top;
			var elementBottom = elementTop + Math.min($(this).height(), windowHeight);
            var topVisible = elementTop >= visibleWindowTop && elementTop <= visibleWindowBottom;
            var bottomVisible = elementBottom >= visibleWindowTop && elementBottom <= visibleWindowBottom;
			visible = topVisible && bottomVisible;
        });

		return visible;
	};

	// If shouldRemove, ensure receiver does not have classNames, otherwise, do nothing
	$.fn.removeClassIf = function(classNames, shouldRemove) {
        return this.each(function() {
			if (shouldRemove) $(this).removeClass(classNames);
        });
	};

    // Make the receiver visible in the scroller (or the browser window if not provided).
    // Callback is invoked with the receiver if provided.
	// Options:
	//		scrollIfVisible: apply the scroll if the receiver is visible in scroller (default is false)
	//  	leaveRoomAtTop: leaves room above the receiver and the top of the scroller (provide a number, in pixels; default is 0)
    //      speed: the time for the scroll animation (use jQuery options; default is "slow")
	$.fn.scrollToBeVisible = function (scroller, options, callback) {

		options = options || {};
		options.leaveRoomAtTop = options.leaveRoomAtTop || 0;

		// Do not scroll if anchor is present in the URL.
        if (location.hash.length > 0)
            return;
		
        return this.first().each(function() {
            
            // Get the window scroll location and height
            var bodyScroll = scroller ? $(scroller).scrollTop() : 0;
            var windowHeight = $(window).height();

            var elementTop = bodyScroll + $(this).offset().top;
            var elementHeight = Math.min($(this).height(), windowHeight - options.leaveRoomAtTop);
			
			// Stop if the receiver is visible
			if (!options.scrollIfVisible) {
				if (callback && $(this).isVisibleToUser(scroller)) return callback.call();
			}
            
			// Calculate the scroll to center element in the middle of the window, leaving the room at the top if needed
			var windowOffset = (windowHeight - elementHeight) / 2;
			windowOffset = Math.max(windowOffset, options.leaveRoomAtTop);
			var scrollTo = Math.max(0, elementTop - windowOffset);
			var speed = typeof(options.speed) == undefined ? "slow" : options.speed;
			$(scroller || "html, body").animate({ scrollTop: scrollTo }, speed, callback);

        });
    };

	// If show is true, show the receiver, otherwise hide it
    // If data-display is specified and hide is false, set the display attribute to its value
	// ex: <div data-display="flex"></div> would be either display:none or display:flex
	$.fn.showIf = function(show) {
        return this.each(function() {
			if (show) {
				var displayValue = $(this).data("display");
				if (displayValue) $(this).css("display", displayValue);
				else $(this).show();
			}
			else $(this).hide();
        });
	};

	// When fieldSelector's value changes, and the new value matches value, show the receiver, otherwise hide it
	$.fn.showForValue = function(fieldSelector, value) {
		var self = this;
		var adjust = function () {
			var show = typeof(value) == "string" ? ($(fieldSelector).val() == value) : (value.indexOf($(fieldSelector).val()) != -1);
			return self.showIf(show);
		}
		$(fieldSelector).change(adjust);
		adjust();
	};

	// If show is true, slide-toggle to open the receiver, otherwise hide it. If speed isn't specified, use "fast" slide.
	$.fn.slideOpenIf = function(show, speed) {
		speed = typeof(speed) == "undefined" ? "fast" : speed;
        return this.each(function() {
			if (show) $(this).slideDown(speed);
			else $(this).slideUp(speed);
        });
	};

	// Return the text from only the first element receiver (excluding its children elements)
	// Return true if all elements are visible (if no elements in list, return true)
	$.fn.textForElementOnly = function() {
	    if (this.children().length == 0) return this.text();

		var $copy = this.children(":first").clone();
		$copy.children().remove();
		return $copy.text();
	};


	// If the receiver has attribute remove it, otherwise, add with with value
	$.fn.toggleAttr = function(attribute, value) {
        return this.each(function() {
			$(this).adjustAttr(attribute, value, !$(this).hasAttr(attribute));
        });
	};
	
    // Wait until an element matching selector exists, then call callback
	$.fn.waitFor = function(callback) {
		if (!callback) return;
		var selector = this.selector
		if ($(selector).isHidden()) setTimeout(function () { $(selector).waitFor(callback) }, 300); 
		else callback.call();
	};

    // Wait until all animations are finished on the receiver or it's children
	$.fn.waitForAnimation = function(callback) {
		if (!callback) return;
		var selector = this.selector
		if ($(selector + ":animated, " + selector + " :animated").length) setTimeout(function () { $(selector).waitForAnimations(callback) }, 100); 
		else callback.call();
	};

})(jQuery);
