/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.SearchSettingsExporter;
import com.brikit.targetedsearch.model.SearchSettingsImporter;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SearchSettingsExportImportAction
extends AbstractTargetedSearchAdminAction
implements ServletRequestAware {
    private static final String SETTINGS_FILENAME = "targeted-search-settings.tsv";
    protected HttpServletRequest servletRequest;
    protected String downloadPath;

    @Override
    public String execute() {
        return "success";
    }

    public String exportSettings() throws Exception {
        String exportFilename = SETTINGS_FILENAME;
        File dataFile = BrikitFile.getConfluenceTempDirectoryPath(exportFilename);
        SearchSettingsExporter exporter = new SearchSettingsExporter();
        exporter.prepareExport();
        BrikitFile.write(exporter.getBuilder().toString(), dataFile);
        this.setDownloadPath(BrikitFile.prepareDownloadPath(dataFile.getPath()) + "?contentType=application/tsv");
        BrikitFile.allowUserToDownload(dataFile);
        return "success";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public MultiPartRequestWrapper getMultiPartRequest() {
        return (MultiPartRequestWrapper)this.getServletRequest();
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    protected void logActionError(String error) {
        BrikitLog.logDebug(error);
        this.addActionError(error);
    }

    protected void logActionErrors(List<String> errors) {
        for (String error : errors) {
            this.logActionError(error);
        }
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public String uploadSettings() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            File[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                File uploadedFile = files[i];
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Uploading: " + uploadedFile.getAbsolutePath());
                SearchSettingsImporter importer = new SearchSettingsImporter();
                importer.importSettings(uploadedFile);
                this.logActionErrors(importer.getErrors());
            }
        }
        if (!this.getActionErrors().isEmpty()) {
            return "error";
        }
        return "success";
    }
}

