/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.CascadingLabel;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import java.util.Collections;
import java.util.List;

public class BasicInformationAction
extends AbstractTargetedSearchAction {
    @Override
    public String execute() {
        JSONObject json = new JSONObject();
        JSONArray folksonomy = new JSONArray();
        for (String label : this.getFolksonomy()) {
            folksonomy.put((Object)label);
        }
        BrikitLog.logDebug("Found cascading labels " + CascadingLabel.cascadingLabelsForPage(this.getPage()) + " for page " + this.getPage() + " with user " + Confluence.getConfluenceUser());
        json.put("filterGroups", (Object)this.filterGroupsAsJSON(this.getAvailableFilterGroups())).put("folksonomy", (Object)folksonomy).put("inheritedLabels", (Object)Filter.toJSONArray(CascadingLabel.inheritedLabelsForPage(this.getPage()))).put("cascadingLabels", (Object)new JSONArray(CascadingLabel.cascadingLabelsForPage(this.getPage()))).put("canCascade", CascadingLabel.canCascadeLabels(this.getSpaceKey())).put("success", true);
        this.setResult(json.toString());
        return "success";
    }

    protected JSONArray filterGroupsAsJSON(List<FilterGroup> filterGroups) {
        JSONArray jsonArray = new JSONArray();
        for (FilterGroup filterGroup : filterGroups) {
            jsonArray.put((Object)filterGroup.toJSONObject());
        }
        return jsonArray;
    }

    public List<FilterGroup> getAvailableFilterGroups() {
        if (!this.isLicensed()) {
            return Collections.EMPTY_LIST;
        }
        BrikitList<FilterGroup> filterGroups = FilterGroup.getFilterGroupsForSpace(this.getSpaceKey());
        Collections.sort(filterGroups);
        return filterGroups;
    }

    public List<String> getFolksonomy() {
        if (!this.isLicensed()) {
            return Collections.EMPTY_LIST;
        }
        BrikitList<String> folksonomy = Folksonomy.getFolksonomy();
        Collections.sort(folksonomy);
        return folksonomy;
    }
}

