/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.search.service.DateRangeEnum;
import com.atlassian.core.util.PairType;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.brikit.core.actions.BrikitActionSupport;
import com.brikit.core.confluence.Confluence;
import com.brikit.targetedsearch.model.SearchSettings;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class AbstractTargetedSearchAction
extends BrikitActionSupport {
    protected List<PairType> dateRanges = new ArrayList<PairType>(5);
    protected String result;
    protected PluginLicenseManager pluginLicenseManager;

    public List<String> getAllSpaceCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        for (Label label : Confluence.getSpaceCategories()) {
            categories.add(label.getName());
        }
        return categories;
    }

    public List<PairType> getDateRanges() {
        if (this.dateRanges.size() != 0) {
            return this.dateRanges;
        }
        this.dateRanges.add(new PairType(null, (Serializable)((Object)Confluence.getText("modified.any.date"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTDAY, (Serializable)((Object)Confluence.getText("modified.today"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTTWODAYS, (Serializable)((Object)Confluence.getText("modified.yesterday"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTWEEK, (Serializable)((Object)Confluence.getText("modified.lastweek"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTMONTH, (Serializable)((Object)Confluence.getText("modified.lastmonth"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTSIXMONTHS, (Serializable)((Object)Confluence.getText("modified.lastsixmonths"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTYEAR, (Serializable)((Object)Confluence.getText("modified.lastyear"))));
        this.dateRanges.add(new PairType((Serializable)DateRangeEnum.LASTTWOYEARS, (Serializable)((Object)Confluence.getText("modified.lasttwoyears"))));
        return this.dateRanges;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public String getResultHTML() {
        return this.result;
    }

    public boolean isLicensed() {
        return TargetedSearch.isLicensed(this.getPluginLicenseManager());
    }

    public boolean isRichLinksDisabled() {
        return SearchSettings.isRichLinksDisabled();
    }

    public void setPluginLicenseManager(PluginLicenseManager licenseManager) {
        this.pluginLicenseManager = licenseManager;
    }

    @Override
    public void setResult(String result) {
        this.result = result;
    }
}

