/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.audit.api.AuditService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAction;
import com.brikit.targetedsearch.model.AuditLog;
import com.brikit.targetedsearch.model.AuditLog74;
import com.brikit.targetedsearch.model.AuditLogInterface;
import com.brikit.targetedsearch.model.CascadingLabel;

public class CascadingLabelsAction
extends AbstractTargetedSearchAction {
    protected String labels;
    @ComponentImport
    protected AuditService auditService;
    @ComponentImport
    protected com.atlassian.confluence.api.service.audit.AuditService auditService74;

    public String add() {
        CascadingLabel.addCascadingLabelToPage(this.getPage(), this.getLabels());
        this.addAuditLogEntry();
        return this.jsonSuccess();
    }

    protected void addAuditLogEntry() {
        try {
            AuditLogInterface auditLog;
            if (Confluence.isConfluenceVersionAtLeast("7.5")) {
                auditLog = new AuditLog();
                ((AuditLog)auditLog).setAuditService(this.getAuditService());
            } else {
                auditLog = new AuditLog74();
                ((AuditLog74)auditLog).setAuditService(this.getAuditService74());
            }
            auditLog.addEntry(this.getPage(), "cascading label(s) added", BrikitString.split(this.getLabels(), " ").join(", "), "", "Cascading labels", "Cascading label(s) added");
        }
        catch (Exception ex) {
            BrikitLog.logError("Failed to create audit log entry for cascading labels (" + this.getLabels() + ") on " + this.getPage(), ex);
        }
    }

    public com.atlassian.confluence.api.service.audit.AuditService getAuditService74() {
        return this.auditService74;
    }

    public void setAuditService74(com.atlassian.confluence.api.service.audit.AuditService auditService74) {
        this.auditService74 = auditService74;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public void validate() {
        super.validate();
        if (!CascadingLabel.canCascadeLabels(this.getSpaceKey())) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

