/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.comalaworkflowsservice;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.comalaworkflowsservice.Comala;
import com.brikit.comalaworkflowsservice.ComalaAccessor;
import com.brikit.comalaworkflowsservice.ComalaServiceFactory;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ComalaAccessorImpl
implements ComalaAccessor {
    private static final Logger log = LoggerFactory.getLogger(ComalaAccessorImpl.class);
    private final ApplicationContext applicationContext;
    private Comala comala;
    private long timestamp = 0L;

    public ComalaAccessorImpl(ApplicationContext applicationContext) {
        this.applicationContext = (ApplicationContext)Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext");
    }

    @Override
    public synchronized Comala getComala() {
        if (new Date().getTime() - this.timestamp > 15000L) {
            this.timestamp = new Date().getTime();
            this.comala = null;
        }
        if (this.comala == null) {
            this.initComala();
        }
        return this.comala;
    }

    private void initComala() {
        PluginAccessor pluginAccessor = (PluginAccessor)ContainerManager.getComponent((String)"pluginAccessor");
        Plugin comalaPlugin = pluginAccessor.getEnabledPlugin("com.comalatech.workflow");
        if (comalaPlugin != null) {
            try {
                Class<?> comalaServiceFactoryClass = this.getComalaServiceFactoryClass();
                if (comalaServiceFactoryClass != null) {
                    this.comala = ((ComalaServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(comalaServiceFactoryClass, 3, false)).get();
                }
            }
            catch (Exception e) {
                log.debug("Could not create Comala", (Throwable)e);
            }
        }
    }

    private Class<?> getComalaServiceFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass("com.comalatech.workflow.ApprovalService");
            this.getClass().getClassLoader().loadClass("com.comalatech.workflow.StateService");
            this.getClass().getClassLoader().loadClass("com.comalatech.workflow.TaskService");
            this.getClass().getClassLoader().loadClass("com.comalatech.workflow.WorkflowService");
            return this.getClass().getClassLoader().loadClass("com.brikit.comalaworkflowsservice.ComalaServiceFactory");
        }
        catch (Exception e) {
            log.info("The necessary Workflows class is unavailable.");
            return null;
        }
    }
}

