/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.model;

import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserKey;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.model.LikeWrapper;
import com.brikit.pinboards.model.PinType;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.Share;
import java.util.Date;

public class FeedEntry
implements Comparable {
    public static final String TIMESTAMP_KEY = "time";
    public static final String PIN_TYPE_KEY = "type";
    public static final String CEO_HANDLE_KEY = "ceo";
    public static final String USER_KEY = "user";
    public static final String DELIM = "---";
    protected Date timestamp;
    protected String handle;
    protected PinType pinType;
    protected UserKey userKey;

    public FeedEntry(Date timestamp, Handle handle) {
        this(timestamp, handle.toString());
    }

    public FeedEntry(long time, String handle) {
        this(new Date(time), handle);
    }

    public FeedEntry(Date timestamp, String handle) {
        this.setTimestamp(timestamp);
        this.setHandle(handle);
        if (this.getCeo() instanceof Page) {
            this.setPinType(PinType.PAGE);
        } else if (this.getCeo() instanceof BlogPost) {
            this.setPinType(PinType.BLOGPOST);
        } else if (this.getCeo() instanceof Comment) {
            this.setPinType(PinType.COMMENT);
        } else if (this.getCeo() instanceof Attachment) {
            this.setPinType(PinType.ATTACHMENT);
        }
    }

    protected FeedEntry(long timestamp, String handle, String pinType, String userKey) {
        this(new Date(timestamp), handle);
        this.setPinType(PinType.get(pinType));
        this.setUserKey(new UserKey(userKey));
    }

    public FeedEntry(ConfluenceEntityObject entityObject) {
        this(entityObject.getLastModificationDate(), Pinboard.getHandleStringFor(entityObject));
    }

    public FeedEntry(LikeWrapper likeWrapper) {
        this(likeWrapper.getCreationDate(), Pinboard.getHandleStringFor((ConfluenceEntityObject)likeWrapper.getSubject()));
        this.setPinType(PinType.LIKE);
        if (likeWrapper.getUser() != null) {
            this.setUserKey(likeWrapper.getUser().getKey());
        }
    }

    public FeedEntry(Share share) {
        this(share.getTime(), Pinboard.getHandleStringFor((ConfluenceEntityObject)share.getContentEntity()));
        this.setPinType(PinType.SHARE);
        this.setUserKey(Confluence.getUserKey((String)share.getUserKey()));
    }

    public FeedEntry(String fromString) {
        BrikitList bits = BrikitString.split((String)fromString, (String)DELIM);
        this.setTimestamp(new Date(Long.parseLong((String)bits.get(0))));
        this.setPinType(PinType.get((String)bits.get(1)));
        this.setHandle((String)bits.get(2));
        if (bits.size() > 3) {
            this.setUserKey(new UserKey((String)bits.get(3)));
        }
    }

    public static FeedEntry unpack(String jsonString) {
        JSONObject json = new JSONObject(jsonString);
        return new FeedEntry(json.getLong(TIMESTAMP_KEY), json.getString(CEO_HANDLE_KEY), json.getString(PIN_TYPE_KEY), json.getString(USER_KEY));
    }

    public int compareTo(Object o) {
        FeedEntry other = (FeedEntry)o;
        int result = other.getTimestamp().compareTo(this.getTimestamp());
        return result == 0 ? other.getHandle().compareTo(this.getHandle()) : result;
    }

    public boolean equals(Object obj) {
        return obj instanceof FeedEntry && this.uniqueString().equals(((FeedEntry)obj).uniqueString());
    }

    public ConfluenceEntityObject getCeo() {
        return Confluence.getEntityFor((String)this.getHandle());
    }

    public String getHandle() {
        return this.handle;
    }

    public PinType getPinType() {
        return this.pinType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public ConfluenceUser getUser() {
        return Confluence.getConfluenceUser((UserKey)this.getUserKey());
    }

    public UserKey getUserKey() {
        if (this.userKey == null && this.getCeo() != null) {
            this.userKey = Confluence.getUserKey((ConfluenceUser)this.getCeo().getLastModifier());
        }
        return this.userKey;
    }

    public int hashCode() {
        return this.uniqueString().hashCode();
    }

    public boolean isAttachment() {
        return PinType.ATTACHMENT == this.getPinType();
    }

    public boolean isBlogpost() {
        return PinType.BLOGPOST == this.getPinType();
    }

    public boolean isComment() {
        return PinType.COMMENT == this.getPinType();
    }

    public boolean isLike() {
        return PinType.LIKE == this.getPinType();
    }

    public boolean isPage() {
        return PinType.PAGE == this.getPinType();
    }

    public boolean isShare() {
        return PinType.SHARE == this.getPinType();
    }

    public String pack() {
        JSONObject json = new JSONObject();
        json.put(TIMESTAMP_KEY, this.getTimestamp().getTime()).put(PIN_TYPE_KEY, (Object)this.getPinType().getName()).put(CEO_HANDLE_KEY, (Object)this.getHandle()).put(USER_KEY, (Object)(this.getUserKey() == null ? "" : this.getUserKey().getStringValue()));
        return json.toString();
    }

    protected void setHandle(String handle) {
        this.handle = handle;
    }

    protected void setPinType(PinType pinType) {
        this.pinType = pinType;
    }

    protected void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    protected void setUserKey(UserKey userKey) {
        this.userKey = userKey;
    }

    public String toString() {
        return (this.getTimestamp() == null ? "" : Long.valueOf(this.getTimestamp().getTime())) + DELIM + (this.getPinType() == null ? "" : this.getPinType().getName()) + DELIM + this.getHandle() + DELIM + this.getUserKey();
    }

    protected String uniqueString() {
        String type = this.getPinType() == null ? "" : this.getPinType().getName();
        return type + DELIM + this.getHandle() + DELIM + this.getUserKey();
    }
}

