/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.listeners;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.like.LikeCreatedEvent;
import com.atlassian.confluence.event.events.like.LikeRemovedEvent;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.listeners.BrikitEventListener;
import com.brikit.pinboards.model.LikeWrapper;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.PinboardFeed;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class EngagementListener
extends BrikitEventListener {
    @Inject
    public EngagementListener(EventPublisher eventPublisher) {
        super(eventPublisher);
    }

    protected void attachmentChanged(AttachmentEvent event) {
        for (Attachment attachment : event.getAttachments()) {
            if (Confluence.getPage((Attachment)attachment) == null) continue;
            PinboardFeed.addToFeeds((AbstractLabelableEntityObject)attachment, "attachment");
        }
    }

    @EventListener
    public void attachmentCreateEvent(AttachmentCreateEvent event) {
        this.attachmentChanged((AttachmentEvent)event);
    }

    @EventListener
    public void attachmentRemoveEvent(AttachmentRemoveEvent event) {
        for (Attachment attachment : event.getAttachments()) {
            if (Confluence.getPage((Attachment)attachment) == null) continue;
            PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)attachment, "attachment");
        }
    }

    @EventListener
    public void attachmentUpdateEvent(AttachmentUpdateEvent event) {
        this.attachmentChanged((AttachmentEvent)event);
    }

    protected void blogPostChanged(BlogPostEvent event) {
        PinboardFeed.addToFeeds((AbstractLabelableEntityObject)event.getBlogPost(), "blogpost");
    }

    @EventListener
    public void blogPostCreateEvent(BlogPostCreateEvent event) {
        this.blogPostChanged((BlogPostEvent)event);
    }

    @EventListener
    public void blogPostRestoreEvent(BlogPostRestoreEvent event) {
        this.blogPostTrashed((BlogPostEvent)event);
    }

    protected void blogPostTrashed(BlogPostEvent event) {
        PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)event.getBlogPost(), "blogpost");
    }

    @EventListener
    public void blogPostTrashedEvent(BlogPostTrashedEvent event) {
        this.blogPostTrashed((BlogPostEvent)event);
    }

    @EventListener
    public void blogPostUpdateEvent(BlogPostUpdateEvent event) {
        this.blogPostChanged((BlogPostEvent)event);
    }

    protected void commentChanged(CommentEvent event) {
        Comment comment = event.getComment();
        AbstractPage ceo = Confluence.getPage((Comment)comment);
        if (ceo instanceof AbstractPage) {
            PinboardFeed.addToFeeds((AbstractLabelableEntityObject)comment, (AbstractLabelableEntityObject)ceo, "social");
        }
    }

    @EventListener
    public void commentCreateEvent(CommentCreateEvent event) {
        this.commentChanged((CommentEvent)event);
    }

    @EventListener
    public void commentRemoveEvent(CommentRemoveEvent event) {
        Comment comment = event.getComment();
        AbstractPage ceo = Confluence.getPage((Comment)comment);
        if (ceo instanceof AbstractPage) {
            PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)comment, "social");
        }
    }

    @EventListener
    public void commentUpdateEvent(CommentUpdateEvent event) {
        this.commentChanged((CommentEvent)event);
    }

    @EventListener
    public void labelAddEvent(LabelAddEvent event) {
        Labelable labeled = event.getLabelled();
        if (labeled instanceof AbstractLabelableEntityObject) {
            PinboardFeed.resetFeedsForLabel(event.getLabel());
        }
    }

    @EventListener
    public void labelRemoveEvent(LabelRemoveEvent event) {
        Labelable labeled = event.getLabelled();
        if (labeled instanceof AbstractLabelableEntityObject) {
            PinboardFeed.resetFeedsForLabel(event.getLabel());
        }
    }

    @EventListener
    public void likeCreatedEvent(LikeCreatedEvent event) {
        LikeWrapper likeWrapper = new LikeWrapper(Pinboard.getHandleStringFor((ConfluenceEntityObject)event.getContent()), event.getOriginatingUser(), event.getTimestamp());
        PinboardFeed.addToFeeds(likeWrapper);
    }

    @EventListener
    public void likeRemovedEvent(LikeRemovedEvent event) {
        LikeWrapper likeWrapper = new LikeWrapper(Pinboard.getHandleStringFor((ConfluenceEntityObject)event.getContent()), event.getOriginatingUser(), event.getTimestamp());
        PinboardFeed.removeFromFeeds(likeWrapper);
    }

    protected void pageChanged(PageEvent event) {
        PinboardFeed.addToFeeds((AbstractLabelableEntityObject)event.getPage(), "page");
    }

    @EventListener
    public void pageCreateEvent(PageCreateEvent event) {
        this.pageChanged((PageEvent)event);
    }

    @EventListener
    public void pageRestoreEvent(PageRestoreEvent event) {
        this.pageChanged((PageEvent)event);
    }

    @EventListener
    public void pageTrashedEvent(PageTrashedEvent event) {
        PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)event.getPage(), "page");
    }

    @EventListener
    public void pageUpdateEvent(PageUpdateEvent event) {
        this.pageChanged((PageEvent)event);
    }
}

