/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.actions;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.core.bean.EntityObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.actions.PinboardsActionSupport;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.PinboardFeed;
import com.brikit.pinboards.tiles.Tile;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class LoadPinboardAction
extends PinboardsActionSupport {
    protected ActiveObjects activeObjects;
    protected int itemsPerFetch = 10;
    protected String labels;
    protected String matchLabels;
    protected String excludeLabels;
    protected boolean includePages;
    protected boolean includeBlogposts;
    protected boolean includeFiles;
    protected boolean includeSocial;
    protected String spaceFilter;
    protected String spaceKeysOrCategories;
    protected String defaultSpaceKey;
    protected String lastEntryString;
    protected FeedEntry lastEntry;
    protected List<List<Object>> nextBatch;
    protected PinboardFeed pinboardFeed;

    public String execute() throws Exception {
        if (ExternalDevelopmentMode.isDeveloperMode() && Confluence.isBrowserReload() && this.getLastEntry() == null) {
            Pinboard.resetCaches();
        }
        try {
            long start = new Date().getTime();
            List<FeedEntry> feedEntries = this.getPinboardFeed().getNextBatch(this.getLastEntry(), this.getItemsPerFetch());
            this.renderFeedEntries(feedEntries);
            BrikitLog.log((String)("Pinboard batch took " + (new Date().getTime() - start) + "ms"));
            return "success";
        }
        catch (Exception ex) {
            this.addActionError(Confluence.getText((String)"com.brikit.pinboards.error.get.next.batch.error"), new Object[]{ex});
            BrikitLog.logError((String)Confluence.getText((String)"com.brikit.pinboards.error.get.next.batch.error"), (Exception)ex);
            return "error";
        }
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public String getDefaultSpaceKey() {
        return this.defaultSpaceKey;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public int getItemsPerFetch() {
        return this.itemsPerFetch;
    }

    public String getLabels() {
        return this.labels;
    }

    public FeedEntry getLastEntry() {
        if (this.lastEntry == null && BrikitString.isSet((String)this.getLastEntryString())) {
            this.lastEntry = new FeedEntry(Confluence.urlDecode((String)this.getLastEntryString()));
        }
        return this.lastEntry;
    }

    public String getLastEntryString() {
        return this.lastEntryString;
    }

    public EntityObject getLastViewed() {
        if (this.getLastEntry() == null) {
            return null;
        }
        try {
            HibernateHandle handle = new HibernateHandle(this.getLastEntry().getHandle());
            return Confluence.getEntityFor((Handle)handle);
        }
        catch (ParseException ex) {
            BrikitLog.logError((String)("Unable to find last pinboard feed item: " + this.getLastEntry().getHandle()), (Exception)ex);
            return null;
        }
    }

    public String getMatchLabels() {
        return this.matchLabels;
    }

    public List<List<Object>> getNextBatch() {
        if (this.nextBatch == null) {
            this.nextBatch = new ArrayList<List<Object>>();
        }
        return this.nextBatch;
    }

    public PinboardFeed getPinboardFeed() {
        if (this.pinboardFeed == null) {
            this.pinboardFeed = PinboardFeed.feedFor(this.getLabels(), this.isMatchAllLabels(), this.getExcludeLabels(), this.isIncludePages(), this.isIncludeBlogposts(), this.isIncludeFiles(), this.isIncludeSocial(), this.getSpaceFilter(), this.getSpaceKeysOrCategories(), this.getDefaultSpaceKey(), this.getActiveObjects());
        }
        return this.pinboardFeed;
    }

    public String getSpaceFilter() {
        return this.spaceFilter;
    }

    public String getSpaceKeysOrCategories() {
        return this.spaceKeysOrCategories;
    }

    public boolean isIncludeBlogposts() {
        return this.includeBlogposts;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public boolean isIncludePages() {
        return this.includePages;
    }

    public boolean isIncludeSocial() {
        return this.includeSocial;
    }

    protected boolean isMatchAllLabels() {
        return "all".equals(this.getMatchLabels());
    }

    protected void renderFeedEntries(List<FeedEntry> feedEntries) {
        for (FeedEntry feedEntry : feedEntries) {
            Tile tile = Tile.get(feedEntry, (ConfluenceActionSupport)this);
            if (tile == null) continue;
            try {
                String renderedContent = tile.getRenderedTile();
                this.getNextBatch().add(Arrays.asList(feedEntry, renderedContent));
            }
            catch (IOException ex) {
                BrikitLog.logError((String)("Removing " + feedEntry + " from pinboard feeds due to:"), (Exception)ex);
                PinboardFeed.removeFromFeeds(feedEntry);
            }
        }
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    @StrutsParameter
    public void setDefaultSpaceKey(String defaultSpaceKey) {
        this.defaultSpaceKey = defaultSpaceKey;
    }

    @StrutsParameter
    public void setExcludeLabels(String excludeLabels) {
        this.excludeLabels = excludeLabels;
    }

    @StrutsParameter
    public void setIncludeBlogposts(boolean includeBlogposts) {
        this.includeBlogposts = includeBlogposts;
    }

    @StrutsParameter
    public void setIncludeFiles(boolean includeFiles) {
        this.includeFiles = includeFiles;
    }

    @StrutsParameter
    public void setIncludePages(boolean includePages) {
        this.includePages = includePages;
    }

    @StrutsParameter
    public void setIncludeSocial(boolean includeSocial) {
        this.includeSocial = includeSocial;
    }

    @StrutsParameter
    public void setItemsPerFetch(int itemsPerFetch) {
        this.itemsPerFetch = itemsPerFetch;
    }

    @StrutsParameter
    public void setLabels(String labels) {
        this.labels = labels;
    }

    @StrutsParameter
    public void setLastEntryString(String lastEntryString) {
        this.lastEntryString = lastEntryString;
    }

    @StrutsParameter
    public void setMatchLabels(String matchLabels) {
        this.matchLabels = matchLabels;
    }

    @StrutsParameter
    public void setSpaceFilter(String spaceFilter) {
        this.spaceFilter = spaceFilter;
    }

    @StrutsParameter
    public void setSpaceKeysOrCategories(String spaceKeysOrCategories) {
        this.spaceKeysOrCategories = spaceKeysOrCategories;
    }
}

