/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import java.util.Arrays;
import java.util.Map;

public class PinboardMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "pinboards/templates/macros/pinboard.vm";
    public static final String SPACE_FILTER_PARAM = "space-filter";
    public static final String SPACE_CATEGORIES_PARAM = "space-categories";
    public static final String EXCLUDE_SPACE_CATEGORIES_PARAM = "exclude-space-categories";
    public static final String LABELS_PARAM = "labels";
    public static final String TILE_WIDTH_PARAM = "tile-width";
    public static final String TILE_MAX_CONTENT_HEIGHT_PARAM = "tile-max-content-height";
    public static final String INCLUDE_PAGES_PARAM = "include-pages";
    public static final String INCLUDE_BLOGPOSTS_PARAM = "include-blogposts";
    public static final String INCLUDE_FILES_PARAM = "include-files";
    public static final String INCLUDE_SOCIAL_PARAM = "include-social";

    public synchronized String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.hasStringValue("key") && !Confluence.isSpace((String)macroContext.stringValue("key"))) {
            throw new MacroExecutionException(Confluence.getText((String)"com.brikit.pinboards.space.key.does.not.exist", Arrays.asList(macroContext.stringValue("key"))));
        }
        if (!(macroContext.booleanValue(INCLUDE_PAGES_PARAM) || macroContext.booleanValue(INCLUDE_BLOGPOSTS_PARAM) || macroContext.booleanValue(INCLUDE_FILES_PARAM) || macroContext.booleanValue(INCLUDE_SOCIAL_PARAM))) {
            macroContext.velocityContextAdd((Object)INCLUDE_PAGES_PARAM, (Object)true);
            macroContext.velocityContextAdd((Object)INCLUDE_BLOGPOSTS_PARAM, (Object)true);
            macroContext.velocityContextAdd((Object)INCLUDE_FILES_PARAM, (Object)true);
            macroContext.velocityContextAdd((Object)INCLUDE_SOCIAL_PARAM, (Object)true);
        }
        macroContext.velocityContextAdd((Object)TILE_WIDTH_PARAM, (Object)macroContext.integerValue(TILE_WIDTH_PARAM, 293));
        macroContext.velocityContextAdd((Object)TILE_MAX_CONTENT_HEIGHT_PARAM, (Object)macroContext.integerValue(TILE_MAX_CONTENT_HEIGHT_PARAM, 520));
        Space space = macroContext.hasStringValue("key") ? macroContext.spaceFromValue("key") : macroContext.getSpace();
        macroContext.velocityContextAdd((Object)"labelList", (Object)macroContext.commaSeparatedListValue(LABELS_PARAM));
        macroContext.velocityContextAdd((Object)"space", (Object)space);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

