(function ($) {
	
	BrikitColumn = function (column, browser, options) {
		this.$column = $(column);
		this.$column.data("column", this);
		this.browser = browser;
		this.initialize();
	};
	
	var prototype = BrikitColumn.prototype;
	
	prototype.$entries = function () {
		return this.$find(".entry");
	};
	
	prototype.$find = function (selector) {
		return selector ? $(selector, this.$column) : this.$column;
	};
	
	prototype.$findEntryByDisplayText = function (displayText) {
		var self = this;
		return self.$entries().filter(function () { return $(this).text() == displayText; }).data("entry");
	};
	
	prototype.$footer = function () {
		return this.$find("footer");
	};
	
	prototype.$header = function () {
		return this.$find("header");
	};
	
	prototype.$options = function () {
		return $(".options", this.$header());
	};
	
	prototype.$scroller = function () {
		return this.$find(".scroller");
	};

	prototype.$selectedEntries = function () {
		return this.$find(".entry.selected");
	};

	prototype.$title = function () {
		return $(".title", this.$header());
	};
	
	prototype.append = function (entry) {
		if (entry instanceof BrikitColumnEntry) this.$scroller().append(entry.$entry);
	};
	
	// options can be a string or an object
	// If options is a string, just create an entry using that string for text.
	// If options is an object, options can include:
	// 		displayText: the text to display
	// 		class: set the class attribute
	// 		data: a javascript object to associate with the the entry
	prototype.createEntry = function (options) {
		options = typeof(options) == "string" ? {displayText: options} : options;
		var $entry = $("<div>").addClass("entry").text(options.displayText).brikitColumnEntry(this, options);
		if (options.class) $entry.addClass(options.class);
		return $entry.data("entry");
	};

	prototype.composeHeader = function ($header) {
		var self = this;
		
		var $title = $("<div>").addClass("title").text(ThemePress.getText($header.attr("title")));
		$header.append($title).removeAttr("title");
		
		$header.append($("<div>").addClass("options"));
		var $menuitems = $("menuitem", $header).each(function () { self.initializeMenuItem($(this)); });
	};
	
	// options can be:
	// 		id: set the id attribute
	//      class: set the class attribute
	//      auiIcon: the suffix of the aui icon font name to use (ex: "success" for aui-iconfont-success)
	//		tooltip: set the title attribute
	//      click: event handler to call when the menuitem is clicked 
	prototype.composeMenuItem = function (options) {
		options = options || {};

		var $menuitem = $("<menuitem>");
		if (options.id) $menuitem.attr("id", options.id);
		if (options.class) $menuitem.addClass(options.class);
		if (options.auiIcon) $menuitem.data("aui-icon", options.auiIcon);
		if (options.tooltip) $menuitem.attr("title", ThemePress.getText(options.tooltip));
		this.initializeMenuItem($menuitem);
		if (options.click) $menuitem.click(options.click);
		return $menuitem;
	};
	
	prototype.data = function (name, data) {
		return this.$find().data(name, data);
	};
	
	prototype.empty = function () {
		this.$scroller().empty();
	};
	
	prototype.entrySelectionChanged = function (event) {
		event.column = this;

		var entry = event.entry;
		
		var stateChanged = false;
		var shouldSelect = entry.isSelected();
		var alreadySelected = this.isSelected();
		stateChanged = shouldSelect != alreadySelected;
	
		if (shouldSelect == alreadySelected) return false;
	
		if (shouldSelect != alreadySelected) this.browser.unselectColumns();
		if (shouldSelect) this.$find().addClass("selected");
	};
	
	prototype.initialize = function () {
		var self = this;

		self.$header().each(function() { self.composeHeader($(this)); });
		
		var $scroller = $("<div>").addClass("scroller");
		if (self.$footer().length) self.$footer().before($scroller);
		else self.$find().append($scroller);
		
		self.$entries().brikitColumnEntry(self);
		
		self.$find()
			.on("click", ".entry", function (e) { $(this).data("entry").entryClicked(e); })
			.on("selection", ".entry", function (event) { self.entrySelectionChanged(event); });

	};
	
	prototype.initializeMenuItem = function ($menuitem) {
		if ($menuitem.data("aui-icon")) $menuitem.append(ThemePress.auiIcon($menuitem.data("aui-icon")));
		this.$options().append($menuitem);
	};
	
	prototype.isSelected = function () {
		return this.$find().hasClass("selected");
	};
	
	prototype.setEnablement = function () {
		var self = this;

		// Enable options buttons for editing designs
		$(".new-design", ".designs").showIf(!isEditing);
		$(".edit-design", ".designs").showIf(!isEditing && design);
		$(".save-design", ".designs").showIf(isEditing && changed);
		$(".discard-changes", ".designs").showIf(isEditing);
		$(".edit-catalog", ".designs").showIf(!design);
		
	};
	
	prototype.unselectEntries = function () {
		this.$entries().removeClass("selected");
	};
	
	$.fn.brikitColumn = function (browser, options) {
	    return this.each(function() {
			new BrikitColumn(this, browser, options);
	    });
	};

})(jQuery);
