/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.tiles;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.brikit.core.confluence.Confluence;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.tiles.Tile;
import java.io.IOException;

public class ShareTile
extends Tile {
    public static final String PINBOARD_SHARE_TEMPLATE = "pinboards/html/macros/pinboard-share-template.vm";

    protected ShareTile(FeedEntry feedEntry, ConfluenceEntityObject content, ConfluenceActionSupport action) {
        super(feedEntry, content, action);
    }

    @Override
    public AbstractPage getPageContext() {
        if (this.isComment()) {
            return Confluence.getPage((Comment)this.getSharedEntity());
        }
        if (this.isAttachment()) {
            return Confluence.getPage((Attachment)this.getSharedEntity());
        }
        return (AbstractPage)this.getSharedEntity();
    }

    @Override
    public String getRenderedContent() throws IOException {
        Tile sharedObjectTile = Tile.get(new FeedEntry(this.getSharedEntity()), this.getSharedEntity(), this.getAction());
        return sharedObjectTile.getRenderedContent();
    }

    @Override
    public String getTemplateLocation() {
        return PINBOARD_SHARE_TEMPLATE;
    }

    public ConfluenceEntityObject getSharedEntity() {
        return this.getContent();
    }

    protected boolean isAttachment() {
        return this.getSharedEntity() instanceof Attachment;
    }

    protected boolean isComment() {
        return this.getSharedEntity() instanceof Comment;
    }
}

