/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.model;

import bucket.core.persistence.hibernate.HibernateHandle;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.core.bean.EntityObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.search.ContentSearch;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.pinboards.cache.PinboardFeedCache;
import com.brikit.pinboards.cache.RenderedContentCache;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.model.LastModifiedSortOrder;
import com.brikit.pinboards.model.LikeWrapper;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.Share;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PinboardFeed {
    public static final String PAGE_TYPE = "page";
    public static final String BLOGPOST_TYPE = "blogpost";
    public static final String ATTACHMENT_TYPE = "attachment";
    public static final String SOCIAL_ACTIVITY_TYPE = "social";
    protected static Set<PinboardFeed> allFeeds;
    protected String labels;
    protected List<String> labelsList;
    protected boolean matchAllLabels;
    protected String excludeLabels;
    protected List<String> excludeLabelsList;
    protected boolean includePages;
    protected boolean includeBlogposts;
    protected boolean includeFiles;
    protected boolean includeSocial;
    protected String spaceFilter;
    protected String spaceKeysOrCategories;
    protected PinboardFeedCache cache;
    protected String cacheKey;
    protected AnyTypeDao anyTypeDao;
    protected ActiveObjects activeObjects;
    ImmutableSet<String> fieldsToFetch;

    private PinboardFeed(String labels, boolean matchAllLabel, String excludeLabels, boolean includePages, boolean includeBlogposts, boolean includeFiles, boolean includeSocial, String spaceFilter, String spaceKeysOrCategories, String defaultSpaceKey, AnyTypeDao anyTypeDao, ActiveObjects activeObjects) {
        this.labels = labels;
        this.matchAllLabels = matchAllLabel;
        this.excludeLabels = excludeLabels;
        this.includePages = includePages;
        this.includeBlogposts = includeBlogposts;
        this.includeFiles = includeFiles;
        this.includeSocial = includeSocial;
        this.spaceFilter = spaceFilter;
        if ("specified keys".equals(this.getSpaceFilter()) && !BrikitString.isSet(spaceKeysOrCategories)) {
            spaceKeysOrCategories = defaultSpaceKey;
        }
        this.spaceKeysOrCategories = spaceKeysOrCategories;
        this.anyTypeDao = anyTypeDao;
        this.activeObjects = activeObjects;
    }

    public static synchronized PinboardFeed feedFor(String labels, boolean matchAllLabel, String excludeLabels, boolean includePages, boolean includeBlogposts, boolean includeFiles, boolean includeSocial, String spaceFilter, String spaceKeysOrCategories, String defaultSpaceKey, AnyTypeDao anyTypeDao, ActiveObjects activeObjects) {
        PinboardFeed newFeed = new PinboardFeed(labels, matchAllLabel, excludeLabels, includePages, includeBlogposts, includeFiles, includeSocial, spaceFilter, spaceKeysOrCategories, defaultSpaceKey, anyTypeDao, activeObjects);
        if (PinboardFeed.getAllFeeds().contains(newFeed)) {
            for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
                if (!feed.equals(newFeed)) continue;
                return feed;
            }
        }
        PinboardFeed.getAllFeeds().add(newFeed);
        return newFeed;
    }

    public boolean acceptsContentForSpace(Space aSpace) {
        if (aSpace == null) {
            return false;
        }
        return this.acceptsAllSpaces() || this.acceptsGlobalSpaces() && aSpace.isGlobal() || this.acceptsSpacesByCategory() && Confluence.spaceHasAnyCategory(aSpace.getKey(), this.getSpaceCategories()) || this.acceptsSpacesByKey() && this.getSpaceKeys().contains(aSpace.getKey());
    }

    public boolean acceptsType(String type) {
        return PAGE_TYPE.equals(type) && this.isIncludePages() || BLOGPOST_TYPE.equals(type) && this.isIncludeBlogposts() || ATTACHMENT_TYPE.equals(type) && this.isIncludeFiles() || SOCIAL_ACTIVITY_TYPE.equals(type) && this.isIncludeSocial();
    }

    public boolean acceptsAllSpaces() {
        return "all spaces".equals(this.getSpaceFilter());
    }

    public boolean acceptsGlobalSpaces() {
        return "all global spaces".equals(this.getSpaceFilter());
    }

    public boolean acceptsSpacesByCategory() {
        return "specified categories".equals(this.getSpaceFilter());
    }

    public boolean acceptsSpacesByKey() {
        return "specified keys".equals(this.getSpaceFilter());
    }

    public static void addToFeeds(AbstractLabelableEntityObject labelable, String type) {
        PinboardFeed.addToFeeds(labelable, labelable, type);
    }

    public static void addToFeeds(AbstractLabelableEntityObject itemToAdd, AbstractLabelableEntityObject labelable, String type) {
        PinboardFeed.removeFromFeeds(itemToAdd);
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(itemToAdd, labelable, type)) {
            try {
                feed.insertToCache(new FeedEntry((ConfluenceEntityObject)itemToAdd));
            }
            catch (IOException ex) {
                BrikitLog.logError("Unable to add to Pinboard feed: " + itemToAdd, ex);
            }
        }
    }

    public static void addToFeeds(LikeWrapper likeWrapper) {
        AbstractLabelableEntityObject likedObject = likeWrapper.getSubject();
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(likedObject, SOCIAL_ACTIVITY_TYPE)) {
            try {
                feed.insertToCache(new FeedEntry(likeWrapper));
            }
            catch (IOException ex) {
                BrikitLog.logError("Unable to add to Pinboard feed: " + likeWrapper, ex);
            }
        }
    }

    public static void addToFeeds(Share share) {
        ContentEntityObject sharedObject = share.getContentEntity();
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting((AbstractLabelableEntityObject)sharedObject, SOCIAL_ACTIVITY_TYPE)) {
            try {
                feed.insertToCache(new FeedEntry(share));
            }
            catch (IOException ex) {
                BrikitLog.logError("Unable to add to Pinboard feed: " + share, ex);
            }
        }
    }

    public static Set<PinboardFeed> getAllFeeds() {
        if (allFeeds == null) {
            allFeeds = new HashSet<PinboardFeed>();
        }
        return allFeeds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PinboardFeed> getFeedsAffecting(AbstractLabelableEntityObject labelable, String type) {
        ArrayList<PinboardFeed> feeds = new ArrayList<PinboardFeed>();
        Class<PinboardFeed> clazz = PinboardFeed.class;
        synchronized (PinboardFeed.class) {
            ArrayList<PinboardFeed> feedsCopy = new ArrayList<PinboardFeed>(PinboardFeed.getAllFeeds());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (PinboardFeed feed : feedsCopy) {
                if (!feed.belongsOnFeed(labelable, type)) continue;
                feeds.add(feed);
            }
            return feeds;
        }
    }

    public static List<PinboardFeed> getFeedsAffecting(AbstractLabelableEntityObject itemToAdd, AbstractLabelableEntityObject labelable, String type) {
        HashSet<PinboardFeed> feeds = new HashSet<PinboardFeed>();
        feeds.addAll(PinboardFeed.getFeedsAffecting(labelable, type));
        if (itemToAdd instanceof Comment) {
            feeds.addAll(PinboardFeed.getFeedsAffecting((AbstractLabelableEntityObject)((Comment)itemToAdd), SOCIAL_ACTIVITY_TYPE));
        }
        return new ArrayList<PinboardFeed>(feeds);
    }

    public static List<PinboardFeed> getFeedsUsingLabel(Label label) {
        ArrayList<PinboardFeed> feeds = new ArrayList<PinboardFeed>();
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            if (!feed.usesLabel(label)) continue;
            feeds.add(feed);
        }
        return feeds;
    }

    public static void removeFromFeeds(AbstractLabelableEntityObject itemToRemove) {
        FeedEntry feedEntry = new FeedEntry((ConfluenceEntityObject)itemToRemove);
        PinboardFeed.removeFromFeeds(feedEntry);
        RenderedContentCache.removeFromCache(feedEntry);
    }

    public static void removeFromFeeds(FeedEntry feedEntry) {
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            try {
                feed.removeFromCache(feedEntry);
            }
            catch (IOException ex) {
                BrikitLog.logError("Unable to remove handle from Pinboard feed: " + feedEntry, ex);
            }
        }
    }

    public static void removeFromFeeds(LikeWrapper likeWrapper) {
        PinboardFeed.removeFromFeeds(new FeedEntry(likeWrapper));
    }

    public static void resetAllFeeds() {
        for (PinboardFeed feed : PinboardFeed.getAllFeeds()) {
            feed.reset();
        }
    }

    public static void resetFeedsForEntity(AbstractLabelableEntityObject entity, String type) {
        for (PinboardFeed feed : PinboardFeed.getFeedsAffecting(entity, type)) {
            feed.reset();
        }
    }

    public static void resetFeedsForLabel(Label label) {
        for (PinboardFeed feed : PinboardFeed.getFeedsUsingLabel(label)) {
            feed.reset();
        }
    }

    protected void adjustAndCacheResults(List results) throws IOException {
        for (Object result : results) {
            FeedEntry feedEntry;
            if (result instanceof LikeWrapper) {
                LikeWrapper like = (LikeWrapper)result;
                feedEntry = new FeedEntry(like);
            } else if (result instanceof Share) {
                Share share = (Share)result;
                feedEntry = new FeedEntry(share);
            } else {
                ConfluenceEntityObject ceo = (ConfluenceEntityObject)result;
                feedEntry = new FeedEntry(ceo.getLastModificationDate(), Pinboard.getHandleStringFor(ceo));
            }
            this.getCache().append(feedEntry);
        }
    }

    public boolean belongsOnFeed(AbstractLabelableEntityObject labellable, String type) {
        if (!this.acceptsType(type)) {
            return false;
        }
        if (this.acceptsContentForSpace(Confluence.getSpace(labellable))) {
            return false;
        }
        if (this.getLabelsList().isEmpty()) {
            return true;
        }
        if (labellable instanceof Comment) {
            Comment comment = (Comment)labellable;
            while (comment.getParent() != null) {
                comment = comment.getParent();
            }
            for (String filename : this.extractReferencedFilenames(Confluence.getBodyAsString((ContentEntityObject)comment), Confluence.getPage(comment))) {
                Attachment attachment = Confluence.getAttachment(Confluence.getPage(comment), filename);
                if (!this.belongsOnFeed((AbstractLabelableEntityObject)attachment, SOCIAL_ACTIVITY_TYPE)) continue;
                return true;
            }
            labellable = Confluence.getPage(comment);
        }
        boolean noMatch = this.isMatchAllLabels() && !Confluence.hasAllLabels(labellable, this.getLabelsList()) || !this.isMatchAllLabels() && !Confluence.hasAnyLabel(labellable, this.getLabelsList()) || Confluence.hasAnyLabel(labellable, this.getExcludeLabelsList());
        return !noMatch;
    }

    public boolean equals(Object obj) {
        return obj instanceof PinboardFeed && this.getCacheKey().equals(((PinboardFeed)obj).getCacheKey());
    }

    protected List<String> extractReferencedFilenames(String storageFormat, AbstractPage pageContext) {
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            for (MacroDefinition macro : MacroParser.extractMacrosFromStorageFormat(pageContext, storageFormat, "attachment-reference", ATTACHMENT_TYPE)) {
                filenames.add(MacroParser.getStringParameter(macro, ATTACHMENT_TYPE));
            }
        }
        catch (XhtmlException ex) {
            BrikitLog.logError("Failed to parse comment", (Exception)((Object)ex));
        }
        return filenames;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public AnyTypeDao getAnyTypeDao() {
        return this.anyTypeDao;
    }

    public synchronized PinboardFeedCache getCache() {
        if (this.cache == null) {
            this.cache = PinboardFeedCache.get(this);
        }
        return this.cache;
    }

    public String getCacheKey() {
        if (this.cacheKey == null) {
            BrikitList<Object> elements = new BrikitList<Object>();
            elements.add(this.getLabels());
            elements.add(this.isMatchAllLabels());
            elements.add(this.getExcludeLabels());
            elements.add(this.isIncludePages());
            elements.add(this.isIncludeBlogposts());
            elements.add(this.isIncludeFiles());
            elements.add(this.isIncludeSocial());
            elements.add(this.getSpaceFilter());
            elements.add(this.getSpaceKeysOrCategories());
            this.cacheKey = elements.join(":");
        }
        return this.cacheKey;
    }

    public String getExcludeLabels() {
        return this.excludeLabels;
    }

    public List<String> getExcludeLabelsList() {
        if (this.excludeLabelsList == null) {
            this.excludeLabelsList = BrikitString.splitCommaSeparated(this.getExcludeLabels());
        }
        return this.excludeLabelsList;
    }

    protected ImmutableSet<String> getFieldsToFetch() {
        if (this.fieldsToFetch == null) {
            this.fieldsToFetch = SearchFieldNames.createWithDefaultValues((String[])new String[]{"spacekey", "space-name", "title", "urlPath", "type", "modified", "lastModifierName", "created", "creatorName"});
        }
        return this.fieldsToFetch;
    }

    public String getLabels() {
        return this.labels;
    }

    public List<String> getLabelsList() {
        if (this.labelsList == null) {
            this.labelsList = BrikitString.splitCommaSeparated(this.getLabels());
        }
        return this.labelsList;
    }

    public synchronized List<FeedEntry> getNextBatch(FeedEntry lastEntry, int count) throws Exception {
        if (!this.getCache().hasEnough(lastEntry, count)) {
            this.loadMoreSearchResults(lastEntry, count);
        }
        return new ArrayList<FeedEntry>(this.getCache().getNextBatch(lastEntry, count));
    }

    public String getSpaceFilter() {
        return this.spaceFilter;
    }

    public List<String> getSpaceCategories() {
        return this.acceptsSpacesByCategory() ? BrikitString.splitCommaOrSpaceSeparated(this.getSpaceKeysOrCategories()) : new BrikitList<String>();
    }

    public List<String> getSpaceKeys() {
        return this.acceptsSpacesByKey() ? BrikitString.splitCommaOrSpaceSeparated(this.getSpaceKeysOrCategories()) : new BrikitList<String>();
    }

    public String getSpaceKeysOrCategories() {
        return this.spaceKeysOrCategories;
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public synchronized void insertToCache(FeedEntry feedEntry) throws IOException {
        this.getCache().insert(feedEntry);
    }

    public boolean isIncludeBlogposts() {
        return this.includeBlogposts;
    }

    public boolean isIncludeFiles() {
        return this.includeFiles;
    }

    public boolean isIncludePages() {
        return this.includePages;
    }

    public boolean isIncludeSocial() {
        return this.includeSocial;
    }

    public boolean isMatchAllLabels() {
        return this.matchAllLabels;
    }

    public void loadMoreSearchResults(FeedEntry lastEntry, int maxResults) throws Exception {
        maxResults = Math.max(maxResults, 100);
        Object lastViewed = lastEntry != null ? this.getAnyTypeDao().findByHandle((Handle)new HibernateHandle(lastEntry.getHandle())) : null;
        Date latestDate = lastViewed instanceof EntityObject ? ((EntityObject)lastViewed).getLastModificationDate() : new Date();
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        ArrayList<Object> contentTypes = new ArrayList<ContentTypeEnum>();
        if (this.isIncludePages()) {
            contentTypes.add(ContentTypeEnum.PAGE);
        }
        if (this.isIncludeBlogposts()) {
            contentTypes.add(ContentTypeEnum.BLOG);
        }
        if (this.isIncludeFiles()) {
            contentTypes.add(ContentTypeEnum.ATTACHMENT);
        }
        SearchResults contentResults = ContentSearch.searchByDateAndLabel(this.getFieldsToFetch(), ContentSearch.spaceCategoryQuery(this.getSpaceFilter()), ContentSearch.inSpaceQuery(this.getSpaceFilter(), BrikitString.splitCommaSeparated(this.getSpaceKeysOrCategories())), ContentSearch.contentTypeQuery(contentTypes), ContentSearch.dateRangeQuery(null, latestDate), ContentSearch.labelsQuery(BrikitString.splitCommaSeparated(this.getLabels()), this.isMatchAllLabels(), BrikitString.splitCommaSeparated(this.getExcludeLabels())), ContentSearch.subsetResultFilter(0, maxResults), ContentSearch.searchSort("most recent"));
        searchResults.addAll(contentResults.getAll());
        SearchResult earliestContent = (SearchResult)new BrikitList(contentResults.getAll()).last();
        if (earliestContent == null) {
            return;
        }
        Date earliestDate = earliestContent.getCreationDate();
        if (this.isIncludeSocial()) {
            contentTypes = new ArrayList();
            contentTypes.add(ContentTypeEnum.COMMENT);
            SearchResults commentResults = ContentSearch.searchByDate(this.getFieldsToFetch(), ContentSearch.spaceCategoryQuery(this.getSpaceFilter()), ContentSearch.inSpaceQuery(this.getSpaceFilter(), BrikitString.splitCommaSeparated(this.getSpaceKeysOrCategories())), ContentSearch.contentTypeQuery(contentTypes), ContentSearch.dateRangeQuery(earliestDate, latestDate), null, ContentSearch.searchSort("most recent"));
            for (SearchResult result : commentResults) {
                ConfluenceEntityObject confluenceEntityObject = Confluence.getEntityFor(result);
                if (!(confluenceEntityObject instanceof Comment) || !this.belongsOnFeed((AbstractLabelableEntityObject)Confluence.getPage((Comment)confluenceEntityObject), SOCIAL_ACTIVITY_TYPE)) continue;
                searchResults.add(result);
            }
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<ContentEntityObject> likableObjects = new ArrayList<ContentEntityObject>();
        for (SearchResult searchResult : searchResults) {
            ConfluenceEntityObject ceo = Confluence.getEntityFor(searchResult.getHandle());
            results.add(ceo);
            if (!(ceo instanceof ContentEntityObject)) continue;
            likableObjects.add((ContentEntityObject)ceo);
        }
        if (this.isIncludeSocial()) {
            Map likes = Confluence.getLikeManager().getLikes(likableObjects);
            for (List likeList : likes.values()) {
                for (Like like : likeList) {
                    if (like.getCreatedDate().getTime() < earliestDate.getTime() || like.getCreatedDate().getTime() > latestDate.getTime()) continue;
                    results.add(new LikeWrapper(like));
                }
            }
            List<Share> list = Share.getSharesByTimestamp(this.getActiveObjects(), earliestDate, latestDate);
            for (Share share : list) {
                ContentEntityObject ceo = share.getContentEntity();
                if (ceo instanceof Comment) {
                    ceo = Confluence.getPage((Comment)ceo);
                }
                if (!Confluence.hasLabels((AbstractLabelableEntityObject)ceo, this.getLabelsList(), this.isMatchAllLabels())) continue;
                results.add(share);
            }
        }
        Collections.sort(results, new LastModifiedSortOrder(true));
        this.adjustAndCacheResults(results);
    }

    public synchronized void removeFromCache(FeedEntry feedEntry) throws IOException {
        this.getCache().remove(feedEntry);
    }

    public synchronized void reset() {
        PinboardFeedCache.get(this).reset();
    }

    public boolean usesLabel(Label label) {
        return this.usesLabel(label.getName());
    }

    public boolean usesLabel(String labelString) {
        return this.getLabelsList().contains(labelString);
    }
}

