/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class BrikitApps {
    public static final String BLUEPRINT_MAKER_APP_KEY = "com.brikit.blueprintmaker";
    public static final String CALENDAR_INTEGRATIONS_APP_KEY = "com.brikit.calendarintegrations";
    public static final String CONTENT_FLOW_APP_KEY = "com.brikit.contentflow";
    public static final String TARGETED_SEARCH_APP_KEY = "com.brikit.targetedsearch";
    public static final String THEME_PRESS_APP_KEY = "com.brikit.themepress";
    public static final String CONTENT_FLOW_DOCUMENT_IDENTIFIER_SEARCH_FIELD_NAME = "document";

    public static String documentIdentifier(Page page) {
        Object service = BrikitApps.getContentFlowVelocityContext();
        if (service == null) {
            return null;
        }
        try {
            Method method = service.getClass().getMethod("documentIdentifier", Page.class);
            return (String)method.invoke(service, page);
        }
        catch (Exception e) {
            BrikitLog.logDebug("Unable to lookup documentIdentifier when calling documentIdentifier(Page): " + page, e);
            return null;
        }
    }

    public static JSONObject filterGroupJSON(String filterGroupName) {
        Object service = BrikitApps.getTargetedSearchTaxonomyServiceVelocityContext();
        if (service == null) {
            return null;
        }
        try {
            Method method = service.getClass().getMethod("getFiltersForGroupName", String.class);
            return (JSONObject)method.invoke(service, filterGroupName);
        }
        catch (Exception e) {
            BrikitLog.logDebug("Unable to provide filters for blueprint field when calling getFiltersForGroupName(String): " + filterGroupName, e);
            return null;
        }
    }

    public static List<String> inheritedLabelsForPage(AbstractPage page) {
        Object service = BrikitApps.getTargetedSearchTaxonomyServiceVelocityContext();
        if (service == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            Method method = service.getClass().getMethod("inheritedLabelsForPage", AbstractPage.class);
            return (List)method.invoke(service, page);
        }
        catch (Exception e) {
            BrikitLog.logDebug("Unable to provide inherited labels for page when calling inheritedLabelsForPage(AbstractPage): " + page, e);
            return Collections.EMPTY_LIST;
        }
    }

    public static Object getContentFlowVelocityContext() {
        return MacroUtils.defaultVelocityContext().get("contentFlow");
    }

    public static Object getTargetedSearchTaxonomyServiceVelocityContext() {
        return MacroUtils.defaultVelocityContext().get("taxonomyService");
    }

    public static boolean isBlueprintMakerEnabled() {
        return Confluence.isAddOnEnabled(BLUEPRINT_MAKER_APP_KEY);
    }

    public static boolean isCalendarIntegrationsEnabled() {
        return Confluence.isAddOnEnabled(CALENDAR_INTEGRATIONS_APP_KEY);
    }

    public static boolean isContentFlowEnabled() {
        return Confluence.isAddOnEnabled(CONTENT_FLOW_APP_KEY);
    }

    public static boolean isTargetedSearchEnabled() {
        return Confluence.isAddOnEnabled(TARGETED_SEARCH_APP_KEY);
    }

    public static boolean isThemePressEnabled() {
        return Confluence.isAddOnEnabled(THEME_PRESS_APP_KEY);
    }
}

