/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import java.util.Arrays;
import java.util.Map;

public class PinboardMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "pinboards/templates/macros/pinboard.vm";
    public static final String SPACE_FILTER_PARAM = "space-filter";
    public static final String SPACE_CATEGORIES_PARAM = "space-categories";
    public static final String EXCLUDE_SPACE_CATEGORIES_PARAM = "exclude-space-categories";
    public static final String LABELS_PARAM = "labels";
    public static final String TILE_WIDTH_PARAM = "tile-width";
    public static final String TILE_MAX_CONTENT_HEIGHT_PARAM = "tile-max-content-height";
    public static final String INCLUDE_PAGES_PARAM = "include-pages";
    public static final String INCLUDE_BLOGPOSTS_PARAM = "include-blogposts";
    public static final String INCLUDE_FILES_PARAM = "include-files";
    public static final String INCLUDE_SOCIAL_PARAM = "include-social";

    @Override
    public synchronized String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.hasStringValue("key") && !Confluence.isSpace(macroContext.stringValue("key"))) {
            throw new MacroExecutionException(Confluence.getText("com.brikit.pinboards.space.key.does.not.exist", Arrays.asList(macroContext.stringValue("key"))));
        }
        if (!(macroContext.booleanValue(INCLUDE_PAGES_PARAM) || macroContext.booleanValue(INCLUDE_BLOGPOSTS_PARAM) || macroContext.booleanValue(INCLUDE_FILES_PARAM) || macroContext.booleanValue(INCLUDE_SOCIAL_PARAM))) {
            macroContext.velocityContextAdd(INCLUDE_PAGES_PARAM, true);
            macroContext.velocityContextAdd(INCLUDE_BLOGPOSTS_PARAM, true);
            macroContext.velocityContextAdd(INCLUDE_FILES_PARAM, true);
            macroContext.velocityContextAdd(INCLUDE_SOCIAL_PARAM, true);
        }
        macroContext.velocityContextAdd(TILE_WIDTH_PARAM, macroContext.integerValue(TILE_WIDTH_PARAM, 293));
        macroContext.velocityContextAdd(TILE_MAX_CONTENT_HEIGHT_PARAM, macroContext.integerValue(TILE_MAX_CONTENT_HEIGHT_PARAM, 520));
        Space space = macroContext.hasStringValue("key") ? macroContext.spaceFromValue("key") : macroContext.getSpace();
        macroContext.velocityContextAdd("labelList", macroContext.commaSeparatedListValue(LABELS_PARAM));
        macroContext.velocityContextAdd("space", space);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

