(function ($) {
	
	Pinboards.Like = function (pinboard) {
		this.pinboard = pinboard;
		this.initialize();
	}
	
	Pinboards.Like.prototype.adjustLikeButton = function ($button, response) {
		if ($(".errorMessage", response).length) {
			Pinboards.Dialog2.alert("Failed to load like status: " + response);
			return;
		}

		$button
			.spinStop().removeClass("button-spinner")
			.adjustAttr("data-likes", "true", response)
			.attr("original-title", response ? Pinboards.getText("com.brikit.pinboards.you.like.this") : Pinboards.getText("com.brikit.pinboards.like"))
			.tooltip({aria:true})
			.find(".aui-icon")
				.adjustClass("aui-iconfont-like", !response)
				.adjustClass("aui-iconfont-star", response);
	};
	
	Pinboards.Like.prototype.initialize = function () {
		
		var self = this;
		
		// Listen for mouse-overs on the tiles
		self.pinboard.pinboard.on("mouseenter", ".pinboard-tile.unknown-like", function () { 
			self.initializeTile.call(this, self);
		});
		
		// Listen for like button clicks
		self.pinboard.pinboard.on("click", ".pinboard-like-button", function () { 
			self.like.call(this, self);
		});
			
	}
	
	Pinboards.Like.prototype.initializeTile = function (self) {
		var $likeButton = $(".pinboard-like-button", this);
		var href =  Pinboards.contextPath + "/plugins/brikit/pinboards/likes.action";
		$.get(href, 
			self.pinboard.entityData(this), 
			function (response, textStatus, jqXHR) {
				self.adjustLikeButton($likeButton, response);
			},
			"json"
		);
		$(this).removeClass("unknown-like");
	};
	
	Pinboards.Like.prototype.like = function (self) {
		var $likeButton = $(this);
		var $tile = $likeButton.closest(".pinboard-tile");
		var usedToLike = $likeButton.hasAttr("data-likes"); // using hasAttr because .data() wasn't resetting(?!)
		var href =  Pinboards.contextPath + "/plugins/brikit/pinboards/" + (usedToLike ? "unlike" : "like") +  ".action";
		self.startWaiting($likeButton);
		$.post(href, 
			self.pinboard.entityData($tile), 
			function (response, textStatus, jqXHR) {
				self.adjustLikeButton($likeButton, response);
			},
			"json"
		);
	};
	
	Pinboards.Like.prototype.startWaiting = function ($likeButton) {
		$likeButton.removeClass("aui-iconfont-like aui-iconfont-favorite").addClass("button-spinner").spin();
	};

})(jQuery);
