/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.tiles;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.pinboards.model.FeedEntry;
import com.brikit.pinboards.tiles.Tile;
import java.io.IOException;
import java.util.Arrays;

public class CommentTile
extends Tile {
    public static final String PINBOARD_COMMENT_TEMPLATE = "pinboards/html/macros/pinboard-comment-template.html";
    public static final String PINBOARD_COMMENT_WITH_IN_RESPONSE_TO_TEMPLATE = "pinboards/html/macros/includes/comment-with-in-response-to.html";

    protected CommentTile(FeedEntry feedEntry, ConfluenceEntityObject content, ConfluenceActionSupport action) {
        super(feedEntry, content, action);
    }

    public Comment getComment() {
        return (Comment)this.getContent();
    }

    @Override
    public AbstractPage getPageContext() {
        return Confluence.getPage(this.getComment());
    }

    @Override
    public String getRenderedContent() throws IOException {
        String storageFormat = this.getComment().getBodyAsString();
        if (MacroParser.hasMacroInStorageFormat(this.getPageContext(), storageFormat, "pinboard")) {
            return Confluence.getText("com.brikit.pinboards.error.cannot.render.page.with.pinboard.macro", Arrays.asList(this.getPageContext().getTitle()));
        }
        String commentContent = Confluence.render(storageFormat, this.getPageContext());
        return this.renderVelocityTemplate(PINBOARD_COMMENT_WITH_IN_RESPONSE_TO_TEMPLATE, commentContent);
    }

    @Override
    public String getTemplateLocation() {
        return PINBOARD_COMMENT_TEMPLATE;
    }
}

