/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.pinboards.listeners;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRestoreEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.event.events.like.AbstractLikeEvent;
import com.atlassian.confluence.event.events.like.LikeCreatedEvent;
import com.atlassian.confluence.event.events.like.LikeRemovedEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.brikit.comalaworkflowsservice.BlogPostPublishedEvent;
import com.brikit.comalaworkflowsservice.PagePublishedEvent;
import com.brikit.core.confluence.Confluence;
import com.brikit.pinboards.model.LikeWrapper;
import com.brikit.pinboards.model.Pinboard;
import com.brikit.pinboards.model.PinboardFeed;

public class EngagementListener
implements EventListener {
    protected static Class[] HANDLED_EVENTS = new Class[]{PageCreateEvent.class, PageUpdateEvent.class, PageTrashedEvent.class, PageRestoreEvent.class, BlogPostCreateEvent.class, BlogPostUpdateEvent.class, BlogPostTrashedEvent.class, BlogPostRestoreEvent.class, PagePublishedEvent.class, BlogPostPublishedEvent.class, CommentCreateEvent.class, CommentUpdateEvent.class, CommentRemoveEvent.class, AttachmentCreateEvent.class, AttachmentUpdateEvent.class, AttachmentRemoveEvent.class, LabelAddEvent.class, LabelRemoveEvent.class, LikeCreatedEvent.class, LikeRemovedEvent.class, ContentPermissionEvent.class, PageMoveEvent.class};

    protected void attachmentChanged(AttachmentEvent event) {
        for (Attachment attachment : event.getAttachments()) {
            if (Confluence.getPage(attachment) == null) continue;
            PinboardFeed.addToFeeds((AbstractLabelableEntityObject)attachment, "attachment");
        }
    }

    protected void attachmentRemoved(AttachmentEvent event) {
        for (Attachment attachment : event.getAttachments()) {
            if (Confluence.getPage(attachment) == null) continue;
            PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)attachment, "attachment");
        }
    }

    protected void blogPostChanged(BlogPostEvent event) {
        PinboardFeed.addToFeeds((AbstractLabelableEntityObject)event.getBlogPost(), "blogpost");
    }

    protected void blogPostTrashed(BlogPostEvent event) {
        PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)event.getBlogPost(), "blogpost");
    }

    protected void commentChanged(CommentEvent event) {
        Comment comment = event.getComment();
        AbstractPage ceo = Confluence.getPage(comment);
        if (ceo instanceof AbstractPage) {
            PinboardFeed.addToFeeds((AbstractLabelableEntityObject)comment, (AbstractLabelableEntityObject)ceo, "social");
        }
    }

    protected void commentRemoved(CommentEvent event) {
        Comment comment = event.getComment();
        AbstractPage ceo = Confluence.getPage(comment);
        if (ceo instanceof AbstractPage) {
            PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)comment, "social");
        }
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    public void handleEvent(Event event) {
        if (event instanceof PageCreateEvent) {
            this.pageChanged((PageEvent)event);
        } else if (event instanceof PageUpdateEvent) {
            this.pageChanged((PageEvent)event);
        } else if (event instanceof PageTrashedEvent) {
            this.pageTrashed((PageEvent)event);
        } else if (event instanceof PageRestoreEvent) {
            this.pageChanged((PageEvent)event);
        } else if (event instanceof BlogPostCreateEvent) {
            this.blogPostChanged((BlogPostEvent)event);
        } else if (event instanceof BlogPostUpdateEvent) {
            this.blogPostChanged((BlogPostEvent)event);
        } else if (event instanceof BlogPostTrashedEvent) {
            this.blogPostTrashed((BlogPostEvent)event);
        } else if (event instanceof BlogPostRestoreEvent) {
            this.blogPostTrashed((BlogPostEvent)event);
        } else if (event instanceof PagePublishedEvent) {
            this.pageChanged((PageEvent)event);
        } else if (event instanceof BlogPostPublishedEvent) {
            this.blogPostChanged((BlogPostEvent)event);
        } else if (event instanceof CommentCreateEvent) {
            this.commentChanged((CommentEvent)event);
        } else if (event instanceof CommentUpdateEvent) {
            this.commentChanged((CommentEvent)event);
        } else if (event instanceof CommentRemoveEvent) {
            this.commentRemoved((CommentEvent)event);
        } else if (event instanceof AttachmentCreateEvent) {
            this.attachmentChanged((AttachmentEvent)event);
        } else if (event instanceof AttachmentUpdateEvent) {
            this.attachmentChanged((AttachmentEvent)event);
        } else if (event instanceof AttachmentRemoveEvent) {
            this.attachmentRemoved((AttachmentEvent)((AttachmentRemoveEvent)event));
        } else if (event instanceof LabelAddEvent) {
            this.labelAdded((LabelEvent)event);
        } else if (event instanceof LabelRemoveEvent) {
            this.labelRemoved((LabelEvent)event);
        } else if (event instanceof LikeCreatedEvent) {
            this.likeAdded((AbstractLikeEvent)event);
        } else if (event instanceof LikeRemovedEvent) {
            this.likeRemoved((AbstractLikeEvent)event);
        }
    }

    protected void labelAdded(LabelEvent event) {
        Labelable labeled = event.getLabelled();
        if (labeled instanceof AbstractLabelableEntityObject) {
            PinboardFeed.resetFeedsForLabel(event.getLabel());
        }
    }

    protected void labelRemoved(LabelEvent event) {
        Labelable labeled = event.getLabelled();
        if (labeled instanceof AbstractLabelableEntityObject) {
            PinboardFeed.resetFeedsForLabel(event.getLabel());
        }
    }

    protected void likeAdded(AbstractLikeEvent event) {
        LikeWrapper likeWrapper = new LikeWrapper(Pinboard.getHandleStringFor((ConfluenceEntityObject)event.getContent()), event.getOriginatingUser(), event.getTimestamp());
        PinboardFeed.addToFeeds(likeWrapper);
    }

    protected void likeRemoved(AbstractLikeEvent event) {
        LikeWrapper likeWrapper = new LikeWrapper(Pinboard.getHandleStringFor((ConfluenceEntityObject)event.getContent()), event.getOriginatingUser(), event.getTimestamp());
        PinboardFeed.removeFromFeeds(likeWrapper);
    }

    protected void pageChanged(PageEvent event) {
        PinboardFeed.addToFeeds((AbstractLabelableEntityObject)event.getPage(), "page");
    }

    protected void pageTrashed(PageEvent event) {
        PinboardFeed.resetFeedsForEntity((AbstractLabelableEntityObject)event.getPage(), "page");
    }
}

