/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.confluence;

import com.atlassian.config.ConfigurationException;
import com.atlassian.core.util.DateUtils;
import com.atlassian.license.License;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicenseType;
import com.atlassian.license.LicenseUtils;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import com.brikit.core.confluence.Confluence;
import java.util.Date;
import java.util.ResourceBundle;

public class ConfluenceLicense {
    protected static ConfluenceLicense license;

    public static int getActiveClusterNodeCount() {
        return Confluence.getClusterManager().getClusterInformation().getMemberCount();
    }

    public static License getConfluenceLicense() {
        return LicenseManager.getInstance().getLicense("CONF");
    }

    public static Date getExpiration() {
        return ConfluenceLicense.getConfluenceLicense().getExpiryDate();
    }

    public static String getExpirationDescription() {
        return ConfluenceLicense.getConfluenceLicense() == null || ConfluenceLicense.getConfluenceLicense().getExpiryDate() == null ? null : DateUtils.dateDifference((long)System.currentTimeMillis(), (long)ConfluenceLicense.getExpiration().getTime(), (long)2L, (ResourceBundle)Confluence.getI18n().getResourceBundle());
    }

    public static ConfluenceLicense getLicense() {
        if (license == null) {
            license = new ConfluenceLicense();
        }
        return license;
    }

    public static int getLicensedUsers() {
        return ConfluenceLicense.getConfluenceLicense().getUsers();
    }

    public static String getOrganization() {
        return ConfluenceLicense.getConfluenceLicense().getOrganisation();
    }

    public static Date getPurchaseDate() {
        return ConfluenceLicense.getConfluenceLicense().getDatePurchased();
    }

    public static int getRegisteredUsers() {
        return Confluence.getUserChecker().getNumberOfRegisteredUsers();
    }

    public static String getSid() {
        try {
            return Confluence.getSidManager().getSid();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSupportEntitlementNumber() {
        return ConfluenceLicense.getConfluenceLicense().getSupportEntitlementNumber();
    }

    public static Date getSupportPeriodEnd() {
        return new Date(LicenseUtils.getSupportPeriodEnd((License)ConfluenceLicense.getConfluenceLicense()));
    }

    public static LicenseType getType() {
        return ConfluenceLicense.getConfluenceLicense() == null ? null : ConfluenceLicense.getConfluenceLicense().getLicenseType();
    }

    public static boolean isClusterLicense() {
        return ConfluenceLicense.getConfluenceLicense().getPermittedClusteredNodes() > 0;
    }

    public static boolean isClusterLicenseInNonClusteredConfluence() {
        return ConfluenceLicense.getConfluenceLicense() != null && ConfluenceLicense.isClusterLicense() && !Confluence.getClusterManager().isClusterSupported();
    }

    public static boolean isClusterRunning() {
        return Confluence.getClusterManager().getClusterInformation().isRunning();
    }

    public static boolean isEvaluationLicense() {
        return ConfluenceLicenseTypeStore.EVALUATION.equals((Object)ConfluenceLicense.getType());
    }

    public static boolean isFreeLicense() {
        LicenseType type = ConfluenceLicense.getType();
        if (type == null) {
            return false;
        }
        return type.equals((Object)ConfluenceLicenseTypeStore.DEMONSTRATION) || type.equals((Object)ConfluenceLicenseTypeStore.DEVELOPER) || type.equals((Object)ConfluenceLicenseTypeStore.EVALUATION) || type.equals((Object)ConfluenceLicenseTypeStore.HOSTED_EVALUATION) || type.equals((Object)ConfluenceLicenseTypeStore.TESTING);
    }

    public static boolean isFreeUnexpiredLicense() {
        return ConfluenceLicense.isFreeLicense() && !ConfluenceLicense.isHasSupportPeriodExpired();
    }

    public static boolean isHasSupportPeriodExpired() {
        return new Date().after(ConfluenceLicense.getSupportPeriodEnd());
    }
}

