(function ($) {
	
	ContentFlow.SpaceAdmin = {

		initialize: function () {
			$(".toggle-all.checkbox").click(ContentFlow.SpaceAdmin.toggleSelections);
			$(".selection .checkbox").change(ContentFlow.SpaceAdmin.setEnablement);
			$(".submit.publish-selected").click(ContentFlow.SpaceAdmin.publishSelectedConfirm);
			$(".submit.restore-pages").click(ContentFlow.SpaceAdmin.restoreSelectedConfirm);

			$("#publish-workflows").on("click", ".remove-workflow .aui-icon", ContentFlow.SpaceAdmin.removeSelectedConfirm);
			
			ContentFlow.SpaceAdmin.setEnablement();
		},
		
		publishSelectedConfirm: function(event) {
			event.preventDefault();
			ContentFlow.Dialog2.doubleConfirm(ContentFlow.getText("com.brikit.contentflow.publish.selected.pages.message"), { title: ContentFlow.getText("com.brikit.contentflow.publish.selected.pages") }, ContentFlow.SpaceAdmin.publishSelectedWorkflows);
		},
		
		publishSelectedWorkflows: function(dialog) {
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/bulkpublish.action",
				data: $("#publish-workflows").serialize(),
                type: "POST",
                success: function(response) {
                    dialog.hide();
                },
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while removing the workflow.", errorThrown);
                },
				complete: function() { location.reload(true); }
            });
			
		},
		
		removeSelectedConfirm: function(event) {
			event.preventDefault();
			ContentFlow.SpaceAdmin.selectedPageId = $(this).closest("tr").data("page-id");
			var pageTitle = $(this).closest("tr").find(".page-title").text();
			ContentFlow.Dialog2.doubleConfirm(ContentFlow.getText("com.brikit.contentflow.remove.selected.workflow.message", [pageTitle]), { title: ContentFlow.getText("com.brikit.contentflow.remove.selected.workflow") }, ContentFlow.SpaceAdmin.removeSelectedWorkflow);
						
		},
		
		removeSelectedWorkflow: function(dialog) {
            const data = {
				pageId: ContentFlow.SpaceAdmin.selectedPageId
			};
            ContentFlow.addToken(data);
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/remove.action",
				data: data,
                type: "POST",
                success: function(response) {
                    dialog.hide();
                },
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while removing the workflow.", errorThrown);
                },
				complete: function() { location.reload(true); }
            });
			
		},
		
		restoreSelectedConfirm: function(event) {
			event.preventDefault();
			ContentFlow.Dialog2.doubleConfirm(ContentFlow.getText("com.brikit.contentflow.restore.selected.pages.message"), { title: ContentFlow.getText("com.brikit.contentflow.restore.selected.pages") }, ContentFlow.SpaceAdmin.restoreSelectedPages);
		},
		
		restoreSelectedPages: function(dialog) {
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/bulkrestore.action",
				data: $("#restore-archived-pages").serialize(),
                type: "POST",
                success: function(response) {
                    dialog.hide();
                },
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while restoring the archived pages.", errorThrown);
                },
				complete: function() { location.reload(true); }
            });
			
		},
		
		selectionCheckboxes: function (checked) {
			return $(".selection .checkbox" + (checked ? ":checked" : ""));
		},
		
		setEnablement: function () {
			// if ($(this).attr("value")) $(".checkbox[value=" + $(this).attr("value") + "]").adjustAttr("checked", "checked", $(this).attr("checked"));
			$(".submit.publish-selected, .submit.restore-pages").adjustAttr("disabled", "disabled", !ContentFlow.SpaceAdmin.selectionCheckboxes(true).length);
		},
		
		toggleSelections: function () {
			ContentFlow.SpaceAdmin.selectionCheckboxes().toggleChecked();
			ContentFlow.SpaceAdmin.setEnablement();
		}
		
	};

	ContentFlow.toInit(ContentFlow.SpaceAdmin.initialize);

})(jQuery);
