(function ($) {
	
	ContentFlow.PageStatus = {

		dialog: function (selector) {
			var $dialog = $("#page-status-dialog");
			return selector ? $(selector, $dialog) : $dialog;
		},
		
		form: function (selector) {
			var $form = ContentFlow.PageStatus.dialog("#page-status-form");
			return selector ? $(selector, $form) : $form;
		},
		
		initialize: function(response) {
			var options = {
				title: ContentFlow.getText("com.brikit.contentflow.set.page.status"),
				id: "page-status-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"),
				closeWithButtonOnly: true
			};

            ContentFlow.Dialog2.dialog(response, options, ContentFlow.PageStatus.savePageStatus);

			ContentFlow.PageStatus.form().submit(function () { return false} );
        },

		savePageStatus: function (dialog) {
			ContentFlow.PageStatus.dialog(".dialog-button-panel .button-panel-button").spin();
			
			var $form = ContentFlow.PageStatus.form();
			$.ajax({
				url: $form.attr("action"),
				data: $form.serialize(),
				method: "POST",
				success: ContentFlow.reloadBrowser,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while saving the page status.", errorThrown);
				}
			})
		},
		
		showSelector: function (event) {
			event.preventDefault();
	        jQuery.ajax({
	            url: $(this).attr("href"),
				data: {
					pageId: ContentFlow.pageId
				},
	            success: ContentFlow.PageStatus.initialize,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while loading the page status panel.", errorThrown);
	            }
	        });
		}
		
	};
	
	ContentFlow.toInit(function ($) {
		$("#content-flow-set-page-status").click(ContentFlow.PageStatus.showSelector);
	});
    
    // Trigger the page status selection wizard when page status lozenge is clicked
    ContentFlow.toInit( function ($) {
        if (!$("#content-flow-set-page-status").length) return;
        
        $(".page-status-macro").click(function(e){
            e.preventDefault();
            $("#content-flow-set-page-status").trigger("click");
        }).css("cursor", "pointer");
    });

})(jQuery);
