/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.brikit.contentflow.model.ao.UserDelegateAO;
import com.brikit.contentflow.model.query.UserDelegateQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import net.java.ao.DBParam;

public class UserDelegate
extends AbstractActiveObjectsModel {
    public static final String USER_DELEGATE_USER_KEY = "com.brikit.contentflow.user.delegate.user.key";
    protected UserDelegateAO activeObject;

    protected UserDelegate(ActiveObjects activeObjects, UserDelegateAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    protected static UserDelegate create(ActiveObjects activeObjects, ConfluenceUser delegatingUser, ConfluenceUser delegate) {
        UserDelegateAO userDelegateAO = (UserDelegateAO)activeObjects.create(UserDelegateAO.class, new DBParam[0]);
        UserDelegate userDelegate = new UserDelegate(activeObjects, userDelegateAO);
        userDelegate.setDelegatingUser(delegatingUser);
        userDelegate.setDelegate(delegate);
        userDelegate.save();
        return userDelegate;
    }

    protected static BrikitList<UserDelegate> fromActiveObjects(ActiveObjects activeObjects, UserDelegateAO[] userDelegateAOs) {
        BrikitList userDelegates = new BrikitList();
        for (UserDelegateAO userDelegateAO : userDelegateAOs) {
            userDelegates.add((Object)new UserDelegate(activeObjects, userDelegateAO));
        }
        return userDelegates;
    }

    public static UserDelegate getUserDelegateForDelegate(ActiveObjects activeObjects, ConfluenceUser delegate) {
        UserDelegateQuery query = new UserDelegateQuery(activeObjects);
        UserDelegateAO[] userDelegateAOs = query.getUserDelegatesForDelegate(delegate);
        return (UserDelegate)((Object)UserDelegate.fromActiveObjects(activeObjects, userDelegateAOs).first());
    }

    public static UserDelegate getUserDelegateForDelegatingUser(ActiveObjects activeObjects, ConfluenceUser delegatingUser) {
        UserDelegateQuery query = new UserDelegateQuery(activeObjects);
        UserDelegateAO[] userDelegateAOs = query.getUserDelegatesForDelegatingUser(delegatingUser);
        return (UserDelegate)((Object)UserDelegate.fromActiveObjects(activeObjects, userDelegateAOs).first());
    }

    public static void setUserDelegateForUser(ActiveObjects activeObjects, ConfluenceUser delegatingUser, ConfluenceUser delegate) {
        if (delegatingUser == null) {
            return;
        }
        UserDelegate userDelegate = UserDelegate.getUserDelegateForDelegatingUser(activeObjects, delegatingUser);
        if (userDelegate == null) {
            UserDelegate.create(activeObjects, delegatingUser, delegate);
        } else {
            userDelegate.updateDelegate(delegate);
        }
    }

    public UserDelegateAO getActiveObject() {
        return this.activeObject;
    }

    public ConfluenceUser getDelegate() {
        ConfluenceUser user = Confluence.getConfluenceUser((UserKey)this.getDelegateUserKey());
        return user;
    }

    protected UserKey getDelegateUserKey() {
        return BrikitString.isSet((String)this.getDelegateUserKeyString()) ? Confluence.getUserKey((String)this.getDelegateUserKeyString()) : null;
    }

    protected String getDelegateUserKeyString() {
        return this.getActiveObject().getDelegateUserKey();
    }

    public ConfluenceUser getDelegatingUser() {
        ConfluenceUser user = Confluence.getConfluenceUser((UserKey)this.getDelegatingUserUserKey());
        return user;
    }

    protected UserKey getDelegatingUserUserKey() {
        return BrikitString.isSet((String)this.getDelegatingUserUserKeyString()) ? Confluence.getUserKey((String)this.getDelegatingUserUserKeyString()) : null;
    }

    protected String getDelegatingUserUserKeyString() {
        return this.getActiveObject().getDelegatingUserUserKey();
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(UserDelegateAO activeObject) {
        this.activeObject = activeObject;
    }

    protected void setDelegate(ConfluenceUser delegate) {
        this.getActiveObject().setDelegateUserKey(delegate == null ? null : Confluence.getUserKeyString((ConfluenceUser)delegate));
    }

    protected void setDelegatingUser(ConfluenceUser delegatingUser) {
        this.getActiveObject().setDelegatingUserUserKey(delegatingUser == null ? null : Confluence.getUserKeyString((ConfluenceUser)delegatingUser));
    }

    public void updateDelegate(ConfluenceUser delegate) {
        this.setDelegate(delegate);
        this.save();
    }
}

