/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.search.CQLComposer;
import com.brikit.core.search.PagingCQLSearcher;
import com.brikit.core.util.BrikitList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentIdentifiers {
    public static Integer addDocumentNumberToPage(Page page, CQLSearchService searchService) {
        if (!DocumentIdentifiers.canHaveDocumentIdentifierCondition(page)) {
            return 0;
        }
        Space space = Confluence.getSpace((AbstractPage)page);
        Page parent = Confluence.getParent((Page)page);
        Integer number = 0;
        Page prexistingPageWithNumber = null;
        while ((prexistingPageWithNumber = DocumentIdentifiers.findPage(DocumentIdentifiers.composeDocumentIdentifier(page, number = Confluence.isChildOfHome((Page)page) ? DocumentIdentifierSettings.getAndIncrementSpaceNextDocumentNumber(space) : DocumentIdentifierSettings.getAndIncrementNextChildDocumentNumber(parent)), space, searchService)) != null) {
        }
        DocumentIdentifierSettings.setPageDocumentNumber(page, number);
        return number;
    }

    public static boolean canHaveDocumentIdentifierCondition(Page page) {
        if (!DocumentIdentifierSettings.isDocumentIdentifiersEnabledForSpace(Confluence.getSpace((AbstractPage)page))) {
            return false;
        }
        Page parent = Confluence.getParent((Page)page);
        return parent != null && !Confluence.isHomePage((AbstractPage)page) && (Confluence.isHomePage((AbstractPage)parent) || DocumentIdentifiers.hasPageDocumentNumber(parent)) && Confluence.isPageInSubtree((Page)page, (Page)Confluence.getSpaceHomePage((AbstractPage)page));
    }

    public static String composeDocumentIdentifier(AbstractPage abstractPage) {
        if (!Confluence.isPage((AbstractPage)abstractPage) || !DocumentIdentifiers.hasPageDocumentNumber((Page)abstractPage)) {
            return "";
        }
        Integer documentNumber = DocumentIdentifiers.documentNumberForPage((Page)abstractPage);
        return DocumentIdentifiers.composeDocumentIdentifier((Page)abstractPage, documentNumber);
    }

    public static String composeDocumentIdentifier(Page page, Integer documentNumberForPage) {
        Space space = Confluence.getSpace((AbstractPage)page);
        if (!DocumentIdentifierSettings.isDocumentIdentifiersEnabledForSpace(space)) {
            return "";
        }
        String libraryCode = DocumentIdentifierSettings.getSpaceLibraryCode(space);
        String identifierPattern = DocumentIdentifierSettings.getSpaceDocumentIdentifierPattern(space);
        BrikitList numbers = new BrikitList();
        while (page != null && !Confluence.isHomePage((AbstractPage)page)) {
            numbers.add(0, (Object)documentNumberForPage);
            if ((page = Confluence.getParent((Page)page)) == null) continue;
            documentNumberForPage = DocumentIdentifiers.documentNumberForPage(page);
        }
        return DocumentIdentifiers.composeDocumentIdentifier(libraryCode, identifierPattern, (List<Integer>)numbers, false);
    }

    public static String composeDocumentIdentifier(String libraryCode, String identifierPattern, List<Integer> nextNumbers, boolean padToFillPattern) {
        if (!DocumentIdentifierSettings.isDocumentIdentifiersEnabled(libraryCode, identifierPattern)) {
            return "";
        }
        String id = libraryCode;
        Pattern chunkPattern = Pattern.compile("([^NaA]+|N+|a|A)");
        Pattern separatorPattern = Pattern.compile("[^NaA]+");
        Pattern numberPattern = Pattern.compile("N+");
        Pattern upperCasePattern = Pattern.compile("A+");
        Pattern lowerCasePattern = Pattern.compile("a+");
        Matcher chunkMatcher = chunkPattern.matcher(identifierPattern);
        int start = 0;
        String lastSeparator = "-";
        while (chunkMatcher.find(start) || !nextNumbers.isEmpty()) {
            String chunk;
            String string = chunk = start < identifierPattern.length() ? chunkMatcher.group(1) : null;
            if (nextNumbers.isEmpty() && !padToFillPattern) break;
            if (chunk == null && !nextNumbers.isEmpty()) {
                Integer nextId = nextNumbers.remove(0);
                id = id + lastSeparator + DocumentIdentifiers.leftPad(nextId, 1, "0");
                continue;
            }
            Matcher separatorMatcher = separatorPattern.matcher(chunk);
            if (separatorMatcher.find()) {
                id = id + chunk;
                lastSeparator = chunk;
            } else {
                Integer nextId = nextNumbers.isEmpty() ? 1 : nextNumbers.remove(0);
                String subId = "";
                int length = chunk.length();
                if (numberPattern.matcher(chunk).find()) {
                    subId = DocumentIdentifiers.leftPad(nextId, length, "0");
                } else if (upperCasePattern.matcher(chunk).find()) {
                    subId = DocumentIdentifiers.recursiveAlphaSubId(nextId, true);
                } else if (lowerCasePattern.matcher(chunk).find()) {
                    subId = DocumentIdentifiers.recursiveAlphaSubId(nextId, false);
                }
                id = id + subId;
            }
            start = chunkMatcher.end();
        }
        return id;
    }

    public static String composeSampleDocumentIdentifier(String libraryCode, String identifierPattern, Integer nextNumber) {
        BrikitList numbers = new BrikitList();
        numbers.add((Object)nextNumber);
        return DocumentIdentifiers.composeDocumentIdentifier(libraryCode, identifierPattern, (List<Integer>)numbers, true);
    }

    public static Integer documentNumberForPage(Page page) {
        return DocumentIdentifierSettings.getPageDocumentNumber(page);
    }

    public static Page findPage(String documentIdentifier, Space space, CQLSearchService searchService) {
        return space == null ? null : DocumentIdentifiers.findPage(documentIdentifier, space.getKey(), searchService);
    }

    public static Page findPage(String documentIdentifier, String spaceKey, CQLSearchService searchService) {
        CQLComposer cqlComposer = new CQLComposer();
        cqlComposer.setQueryString("documentId:" + documentIdentifier);
        PagingCQLSearcher pagingCQLSearcher = new PagingCQLSearcher(searchService, spaceKey);
        int start = 0;
        int size = 10;
        boolean hasMore = true;
        Page page = null;
        while (page == null && hasMore) {
            pagingCQLSearcher.search(cqlComposer.cql(), start, size);
            for (ContentEntityObject ceo : pagingCQLSearcher.convertResults()) {
                if (!(ceo instanceof Page) || !DocumentIdentifiers.composeDocumentIdentifier((AbstractPage)((Page)ceo)).equals(documentIdentifier)) continue;
                page = (Page)ceo;
                break;
            }
            hasMore = pagingCQLSearcher.hasMore();
            start += size;
        }
        return page;
    }

    public static boolean hasPageDocumentNumber(Page page) {
        return DocumentIdentifierSettings.getPageDocumentNumber(page) > 0;
    }

    public static String leftPad(Integer number, int length, String padding) {
        String padded = number.toString();
        while (padded.length() < length) {
            padded = padding + padded;
        }
        return padded;
    }

    public static String libraryCodeFromDocumentIdentifier(String documentIdentifier) {
        Pattern pattern = Pattern.compile("(\\w+)");
        Matcher matcher = pattern.matcher(documentIdentifier);
        return matcher.find() ? matcher.group(1) : "";
    }

    protected static String recursiveAlphaSubId(int id, boolean uppercase) {
        String letters = uppercase ? "ABCDEFGHIJKLMNOPQRSTUVWXYZ" : "abcdefghijklmnopqrstuvwxyz";
        String subId = id > 26 ? DocumentIdentifiers.recursiveAlphaSubId(id / 26, uppercase) : "";
        id = id > 26 ? id % 26 : id;
        return subId + letters.substring(id - 1, id);
    }

    public static void reindexForPage(Page page) {
        if (!DocumentIdentifiers.hasPageDocumentNumber(page)) {
            return;
        }
        DocumentIdentifierSettings.recalculateAndSaveDocumentNumber(page);
        ContentFlowUtils.addPageToIndexQueue((AbstractPage)page);
    }

    public static void reindexForPageAndDescendants(Page page) {
        DocumentIdentifiers.reindexForPage(page);
        for (Page descendant : Confluence.getDescendants((Page)page)) {
            DocumentIdentifiers.reindexForPage(descendant);
        }
    }

    public static void reindexForSpace(String spaceKey) {
        for (Page page : Confluence.getAllPages((Space)Confluence.getSpace((String)spaceKey))) {
            DocumentIdentifiers.reindexForPage(page);
        }
    }
}

