/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ContentFlowUtils {
    public static final String PERMISSION_TYPE = "type";
    public static final String PERMISSION_USER_KEY = "user";
    public static final String PERMISSION_GROUP_NAME = "group";
    public static final String NOTIFICATION_KEY = "com.brikit.contentflow.notification";

    public static void addPageToIndexQueue(AbstractPage abstractPage) {
        Confluence.addAbstractPageToIndexQueueForUpdate((AbstractPage)abstractPage, (boolean)false);
    }

    protected static String contentPermissionsJSON(Collection<ContentPermission> permissions) {
        JSONArray permissionsJSON = new JSONArray();
        for (ContentPermission permission : permissions) {
            JSONObject permissionJSON = new JSONObject();
            permissionJSON.put(PERMISSION_TYPE, (Object)permission.getType());
            permissionJSON.put(PERMISSION_USER_KEY, permission.isUserPermission() ? permission.getUserSubject().getKey().getStringValue() : null);
            permissionJSON.put(PERMISSION_GROUP_NAME, (Object)(permission.isGroupPermission() ? permission.getGroupName() : null));
            permissionsJSON.put((Object)permissionJSON);
        }
        return permissionsJSON.toString();
    }

    public static void setEditPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenEditPermissions(abstractPage);
        }
        Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, (String)"Edit");
    }

    public static void setViewPermissions(AbstractPage abstractPage, ContentPermissionSet permissionSet) {
        if (permissionSet == null) {
            permissionSet = ContentFlowUtils.getOpenViewPermissions(abstractPage);
        }
        Confluence.setContentPermissions((Collection)permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST), (ContentEntityObject)abstractPage, (String)"View");
    }

    public static Collection<ContentPermission> getContentPermissionsFromJSON(String permissionsjSON) {
        HashSet<ContentPermission> contentPermissions = new HashSet<ContentPermission>();
        try {
            JSONArray permissionsArray = new JSONArray(permissionsjSON);
            for (JSONObject json : permissionsArray.objects()) {
                ContentPermission permission;
                String type = json.getString(PERMISSION_TYPE);
                String userKey = json.getString(PERMISSION_USER_KEY);
                String groupName = json.getString(PERMISSION_GROUP_NAME);
                if (BrikitString.isSet((String)userKey)) {
                    ConfluenceUser user = Confluence.getConfluenceUserByUserKey((String)userKey);
                    permission = ContentPermission.createUserPermission((String)type, (ConfluenceUser)user);
                } else {
                    permission = ContentPermission.createGroupPermission((String)type, (String)groupName);
                }
                contentPermissions.add(permission);
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Failed to parse permissions from string: " + permissionsjSON), (Exception)ex);
        }
        return contentPermissions;
    }

    public static ContentPermissionSet getOpenEditPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("Edit", (ContentEntityObject)abstractPage);
    }

    public static ContentPermissionSet getOpenViewPermissions(AbstractPage abstractPage) {
        return new ContentPermissionSet("View", (ContentEntityObject)abstractPage);
    }

    public static boolean jsonHasKeyNotNull(JSONObject json, String key) {
        return json.has(key) && BrikitString.isSet((String)json.getString(key));
    }

    protected static String toJSON(ContentPermissionSet permissionSet) {
        return ContentFlowUtils.contentPermissionsJSON(permissionSet.getAllExcept((Collection)Collections.EMPTY_LIST));
    }
}

