/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.ao.ArchivePolicyAO;
import com.brikit.contentflow.model.ao.ContentFlowConfigurationAO;
import com.brikit.contentflow.model.ao.WorkflowAO;
import com.brikit.contentflow.settings.ContentFlowSettings;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class ContentFlowConfiguration
extends AbstractActiveObjectsModel {
    protected ContentFlowConfigurationAO activeObject;
    protected Workflow automaticWorkflow;
    protected ArchivePolicy archivePolicy;

    protected ContentFlowConfiguration(ActiveObjects activeObjects, ContentFlowConfigurationAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static boolean canSchedule(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return true;
    }

    public static boolean canUseWorkflows(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ContentFlowConfiguration.canUseWorkflows(activeObjects, Confluence.getSpaceKey((AbstractPage)abstractPage));
    }

    public static boolean canUseWorkflows(ActiveObjects activeObjects, String spaceKey) {
        return !ContentFlowSettings.isContentFlowsEnabledGlobally() && ContentFlowConfiguration.isWorkflowsEnabled(activeObjects, spaceKey) || ContentFlowSettings.isContentFlowsEnabledGlobally() && !ContentFlowConfiguration.isWorkflowsDisabled(activeObjects, spaceKey);
    }

    public static void deleteAllSpaceConfigurations(ActiveObjects activeObjects) {
        BrikitList allContentFlowConfigurationAOS = new BrikitList((Object[])((ContentFlowConfigurationAO[])activeObjects.find(ContentFlowConfigurationAO.class)));
        for (ContentFlowConfigurationAO contentFlowConfigurationAO : allContentFlowConfigurationAOS) {
            activeObjects.delete(new RawEntity[]{contentFlowConfigurationAO});
        }
    }

    public static ContentFlowConfiguration forPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ContentFlowConfiguration.forSpace(activeObjects, abstractPage.getSpaceKey());
    }

    public static ContentFlowConfiguration forSpace(ActiveObjects activeObjects, String spaceKey) {
        if (!BrikitString.isSet((String)spaceKey)) {
            return null;
        }
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey});
        BrikitList contentFlowConfigurationAOS = new BrikitList((Object[])((ContentFlowConfigurationAO[])activeObjects.find(ContentFlowConfigurationAO.class, query)));
        ContentFlowConfigurationAO contentFlowConfigurationAO = (ContentFlowConfigurationAO)contentFlowConfigurationAOS.first();
        if (contentFlowConfigurationAOS.isEmpty()) {
            contentFlowConfigurationAO = (ContentFlowConfigurationAO)activeObjects.create(ContentFlowConfigurationAO.class, new DBParam[0]);
            contentFlowConfigurationAO.setSpaceKey(spaceKey);
            contentFlowConfigurationAO.save();
        }
        return new ContentFlowConfiguration(activeObjects, contentFlowConfigurationAO);
    }

    protected static List<ContentFlowConfiguration> fromActiveObjects(ActiveObjects activeObjects, ContentFlowConfigurationAO[] contentFlowConfigurationAOS) {
        ArrayList<ContentFlowConfiguration> contentFlowConfigurations = new ArrayList<ContentFlowConfiguration>(contentFlowConfigurationAOS.length);
        for (ContentFlowConfigurationAO contentFlowConfigurationAO : contentFlowConfigurationAOS) {
            contentFlowConfigurations.add(new ContentFlowConfiguration(activeObjects, contentFlowConfigurationAO));
        }
        return contentFlowConfigurations;
    }

    public static List<ContentFlowConfiguration> getConfigurationsUsingWorkflow(ActiveObjects activeObjects, Workflow workflow) {
        if (workflow == null) {
            return new ArrayList<ContentFlowConfiguration>();
        }
        Query query = Query.select().where("AUTOMATIC_WORKFLOW_AOID = ?", new Object[]{workflow.getActiveObject().getID()});
        ContentFlowConfigurationAO[] contentFlowConfigurationAOS = (ContentFlowConfigurationAO[])activeObjects.find(ContentFlowConfigurationAO.class, query);
        return ContentFlowConfiguration.fromActiveObjects(activeObjects, contentFlowConfigurationAOS);
    }

    public static Workflow getAutomaticWorkflow(ActiveObjects activeObjects, String spaceKey) {
        ContentFlowConfiguration config = ContentFlowConfiguration.forSpace(activeObjects, spaceKey);
        return config == null ? null : config.getAutomaticWorkflow();
    }

    public static Workflow getAutomaticWorkflow(ActiveObjects activeObjects, long pageId) {
        return ContentFlowConfiguration.getAutomaticWorkflow(activeObjects, Confluence.getSpaceKey((long)pageId));
    }

    public static Workflow getAutomaticWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return ContentFlowConfiguration.getAutomaticWorkflow(activeObjects, Confluence.getSpaceKey((AbstractPage)abstractPage));
    }

    public static ContentFlowConfiguration getGlobalConfiguration(ActiveObjects activeObjects) {
        return ContentFlowConfiguration.forSpace(activeObjects, null);
    }

    public static boolean isWorkflowsDisabled(ActiveObjects activeObjects, String spaceKey) {
        return ContentFlowConfiguration.forSpace(activeObjects, spaceKey).getDisableWorkflows();
    }

    public static boolean isWorkflowsEnabled(ActiveObjects activeObjects, String spaceKey) {
        return ContentFlowConfiguration.forSpace(activeObjects, spaceKey).getEnableWorkflows();
    }

    public static void removeFromSpaceConfigurations(ActiveObjects activeObjects, Workflow workflow) {
        for (ContentFlowConfiguration contentFlowConfiguration : ContentFlowConfiguration.getConfigurationsUsingWorkflow(activeObjects, workflow)) {
            contentFlowConfiguration.setAutomaticWorkflow(null);
        }
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public ContentFlowConfigurationAO getActiveObject() {
        return this.activeObject;
    }

    public ArchivePolicy getArchivePolicy() {
        ArchivePolicyAO archivePolicyAO;
        if (this.archivePolicy == null && (archivePolicyAO = this.getActiveObject().getArchivePolicyAO()) != null) {
            this.archivePolicy = new ArchivePolicy(this.getActiveObjects(), archivePolicyAO);
        }
        return this.archivePolicy;
    }

    public Workflow getAutomaticWorkflow() {
        WorkflowAO workflowAO;
        if (this.automaticWorkflow == null && (workflowAO = this.getActiveObject().getAutomaticWorkflowAO()) != null) {
            this.automaticWorkflow = new Workflow(this.getActiveObjects(), workflowAO);
        }
        return this.automaticWorkflow;
    }

    public boolean getDisableWorkflows() {
        return this.getActiveObject().getDisableWorkflows();
    }

    public boolean getEnableWorkflows() {
        return this.getActiveObject().getEnableWorkflows();
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public boolean hasArchivePolicy() {
        return this.getArchivePolicy() != null;
    }

    public boolean hasAutomaticPublishingWorkflow() {
        return this.hasAutomaticWorkflow() && this.getAutomaticWorkflow().isPublishing();
    }

    public boolean hasAutomaticWorkflow() {
        return this.getAutomaticWorkflow() != null;
    }

    public boolean isAutomatic(Workflow workflow) {
        return this.getAutomaticWorkflow() != null && workflow != null && this.getAutomaticWorkflow().getID() == workflow.getID();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(ContentFlowConfigurationAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setArchivePolicy(ArchivePolicy archivePolicy) {
        this.getActiveObject().setArchivePolicyAO(archivePolicy == null ? null : archivePolicy.getActiveObject());
        this.save();
    }

    public void setAutomaticWorkflow(Workflow workflow) {
        this.getActiveObject().setAutomaticWorkflowAO(workflow == null ? null : workflow.getActiveObject());
        this.save();
    }

    public void setDisableWorkflows(boolean disableWorkflows) {
        this.getActiveObject().setDisableWorkflows(disableWorkflows);
        this.save();
    }

    public void setEnableWorkflows(boolean enableWorkflows) {
        this.getActiveObject().setEnableWorkflows(enableWorkflows);
        this.save();
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }
}

