/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageStatusContentEntity;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PageStatusAdminAction
extends ContentFlowActionSupport {
    protected Long key;
    protected String description;
    protected String label;

    @PermittedMethods(value={HttpMethod.POST})
    public String add() {
        PageStatus.create(this.getActiveObjects(), this.getDescription(), this.getLabel());
        return "success";
    }

    public String getDescription() {
        return this.description;
    }

    public Long getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isUsed(PageStatus pageStatus) {
        return PageStatusContentEntity.isInUse(this.getActiveObjects(), pageStatus);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String remove() {
        PageStatus status = PageStatus.getPageStatus(this.getActiveObjects(), this.getKey());
        if (status == null) {
            this.addActionError("Failed to delete PageStatus: " + this.getDescription() + " because no PageStatus was found with matching id: " + this.getKey());
        } else if (status.isInUse()) {
            this.addActionError("Unable to delete PageStatus: " + this.getDescription() + " because one or more pages is using it.");
        }
        if (this.hasActionErrors()) {
            return "error";
        }
        status.delete();
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String save() {
        PageStatus status = PageStatus.getPageStatus(this.getActiveObjects(), this.getKey());
        if (status == null) {
            this.addActionError("Failed to update PageStatus: " + this.getDescription() + " because no PageStatus was found with matching id: " + this.getKey());
        } else if (!BrikitString.isSet((String)this.getDescription())) {
            this.addActionError("Name cannot be blank.");
        }
        if (this.hasActionErrors()) {
            return "error";
        }
        status.setName(this.getDescription());
        status.setLabel(this.getLabel());
        status.save();
        return "success";
    }

    @StrutsParameter
    public void setDescription(String description) {
        this.description = description;
    }

    @StrutsParameter
    public void setKey(Long key) {
        this.key = key;
    }

    @StrutsParameter
    public void setLabel(String label) {
        this.label = label;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("config.insufficient.permissions"));
        }
    }
}

