/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.core.confluence.Confluence;
import javax.inject.Inject;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class DocumentIdentifierMetadataAction
extends ContentFlowActionSupport {
    protected CQLSearchService searchService;
    protected String documentIdentifier;
    protected Integer nextAvailableDocumentIdentifier;

    @Inject
    public DocumentIdentifierMetadataAction(@ComponentImport CQLSearchService searchService) {
        this.searchService = searchService;
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        if (Confluence.isPage((AbstractPage)this.getPage())) {
            Integer id = DocumentIdentifierSettings.getPageDocumentNumber((Page)this.getPage());
            if (id > 0) {
                this.setDocumentIdentifier(id.toString());
            }
            this.setNextAvailableDocumentIdentifier(DocumentIdentifierSettings.getNextAvailableDocumentNumberForPage((Page)this.getPage()));
        }
        return super.execute();
    }

    public String getDocumentIdentifier() {
        return this.documentIdentifier;
    }

    public Integer getNextAvailableDocumentIdentifier() {
        return this.nextAvailableDocumentIdentifier;
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String saveDocumentIdentifier() {
        try {
            Integer id = Integer.parseInt(this.getDocumentIdentifier());
            String documentIdentifier = DocumentIdentifiers.composeDocumentIdentifier((Page)this.getPage(), id);
            Page existingPage = DocumentIdentifiers.findPage(documentIdentifier, this.getSpaceKey(), this.searchService);
            if (existingPage != null && existingPage.getId() != this.getPage().getId()) {
                this.addActionError(Confluence.getText((String)"com.brikit.contentflow.document.identifiers.another.page.has.identifier", (Object[])new Object[]{documentIdentifier, existingPage.getDisplayTitle()}));
                return "error";
            }
            DocumentIdentifierSettings.setPageDocumentNumber((Page)this.getPage(), id);
            DocumentIdentifiers.reindexForPageAndDescendants((Page)this.getPage());
        }
        catch (NumberFormatException ex) {
            this.addActionError(this.getText("com.brikit.contentflow.document.identifiers.integers.only"));
            return "error";
        }
        catch (ClassCastException ex) {
            this.addActionError(this.getText("com.brikit.contentflow.document.identifiers.not.valid.here"));
            return "error";
        }
        return "success";
    }

    @StrutsParameter
    public void setDocumentIdentifier(String documentIdentifier) {
        this.documentIdentifier = documentIdentifier;
    }

    protected void setNextAvailableDocumentIdentifier(Integer nextAvailableDocumentIdentifier) {
        this.nextAvailableDocumentIdentifier = nextAvailableDocumentIdentifier;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isPage((AbstractPage)this.getPage())) {
            this.addActionError(this.getText("com.brikit.contentflow.document.identifiers.not.valid.here"));
        }
        if (!Confluence.canEdit((AbstractPage)this.getPage())) {
            this.addActionError(this.getText("com.brikit.contentflow.insufficient.permissions"));
        }
        if (!DocumentIdentifiers.canHaveDocumentIdentifierCondition((Page)this.getPage())) {
            this.addActionError(this.getText("com.brikit.contentflow.document.identifiers.not.enabled.in.space"));
        }
    }
}

