(function ($) {
	
	ContentFlow.Schedule = {
		
		scheduler: "",

		adjustVisibility: function () {
			ContentFlow.Schedule.adjustWarnings();
			ContentFlow.Schedule.saveWorkflowButton().adjustAttr("disabled", "disabled", !ContentFlow.isDirty);
		},

		adjustWarnings: function () {
		},
		
		clearScheduling: function () {
			$("#release-on-date-field").val('');
			$("#release-on-time-field").val('');
			$("#hide-on-date-field").val('');
			$("#hide-on-time-field").val('');
			
			ContentFlow.isDirty = true;
			ContentFlow.Schedule.adjustVisibility();
		},

		dialog: function (selector) {
			var $dialog = $("#content-flow-dialog");
			return selector ? $(selector, $dialog) : $dialog;
		},
		
		form: function (selector) {
			var $form = ContentFlow.Schedule.dialog("#schedule-page-settings");
			return selector ? $(selector, $form) : $form;
		},
		
		formValueChanged: function (e) {
			ContentFlow.isDirty = true;
			ContentFlow.Schedule.adjustVisibility();
		},
		
		initialize: function(response) {
			var options = {
				size: response.indexOf("aui-message") == -1 ? "medium" : "large", 
				title: ContentFlow.getText("com.brikit.contentflow.schedule.page.name"),
				id: "content-flow-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"), 
				closeWithButtonOnly: true
			};
			
			// Rewire user logo links so they don't have the popup/hover panel nonsense in the editor
			var $response = $(response);
			$(".reviewer-list .userLogoLink", $response)
				.removeClass("userLogoLink").addClass("reviewerLogoLink")
				.find("[title]").removeAttr("title");

			$("#release-on-date-field", $response).datePicker({overrideBrowserDefault: true});
			$("#hide-on-date-field", $response).datePicker({overrideBrowserDefault: true});
			
            ContentFlow.Dialog2.dialog($response, options, ContentFlow.Schedule.saveSchedule, null, ContentFlow.confirmLosingChangesSimple);

			// Make save button easier to grab later
			ContentFlow.$(".button-panel-button").addClass("save-schedule-button");
			
			// Insert clear-scheduling button and click-bind it
			var $clearSchedulingButton = $("<button>").attr("id", "clear-scheduling-button").addClass("button-panel-button").text(ContentFlow.getText("com.brikit.contentflow.clear")).text("Clear");
			ContentFlow.$(".button-panel-button").first().before($clearSchedulingButton);
			$clearSchedulingButton.click( function (e) { ContentFlow.Schedule.clearScheduling(); }.bind(this) );
			
			ContentFlow.isDirty = false;
			ContentFlow.$("input, select").change(ContentFlow.Schedule.formValueChanged);

			ContentFlow.Schedule.adjustVisibility();
        },
		
		saveSchedule: function (dialog) {
			var $form = ContentFlow.Schedule.form();
			$.ajax({
				url: $form.attr("action"),
				data: $form.serialize(),
				type: "POST",
				success: ContentFlow.reloadBrowser,
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while saving the scheduled date and time.", errorThrown);
                }
			})
		},

		saveWorkflowButton: function () {
			return ContentFlow.$(".button-panel-button.save-schedule-button");
		},

		showScheduler: function (event) {
			event.preventDefault();
			
            jQuery.ajax({
                url: ContentFlow.contextPath + "/plugins/contentflow/schedulepagedialog.action",
				data: {
					pageId: ContentFlow.pageId,
					workflowId: $(this).closest("ul").data("workflow-id")
				},
                success: ContentFlow.Schedule.initialize,
                error: function (xhRequest, textStatus, errorThrown) {
                    ContentFlow.alertError("An error occurred while loading the scheduling panel.", errorThrown);
                }
            });
		}
		
	};

	ContentFlow.toInit(ContentFlow.Archive.initialize);
    ContentFlow.toFinalize(function () {
        $("#page-metadata-banner").on("click", "#content-flow-schedule-banner", ContentFlow.Schedule.showScheduler);
        $("#content-flow-schedule-page").click(ContentFlow.Schedule.showScheduler);
    });

})(jQuery);
