(function ($) {
	
	Object.assign(ContentFlow, {
	    contentFlowDialog: "",
		isDirty: false,
	    currentDialog: false
	});

	Object.assign(ContentFlow, {

		$: function (selector) {
			if (selector == "#content-flow-dialog") return $(selector);
			return ContentFlow.contentFlowDialog ? $(selector, ContentFlow.contentFlowDialog) : $(selector, "#content-flow-dialog");
		},

		alertError: function (message, errorThrown) {
			AJS.flag({
               type: "error",
			   body: message + " " + errorThrown
			});
            console.log(errorThrown);
		},
		
		changeUserDelegate: function () {
			var username = ContentFlow.selectedUserName(this) || $(this).val();
			
			var confirmMessage = username 
				? ContentFlow.getText("com.brikit.contentflow.confirm.delegate.selection", [username]) 
				: ContentFlow.getText("com.brikit.contentflow.confirm.delegate.removal");
			if (ContentFlow.updatingDelegate || !confirm(confirmMessage)) return false;
			
			ContentFlow.updatingDelegate = true;
			$(this).val(username);
			$(this).closest("form").submit();
			
			return false;
		},
		
		changeUserDelegatePressed: function (event) {
            if (event.keyCode == 13) {
				return false;
            }
            return true;
		},

		// Makes dropdown menus and inline dialogs disappear
		clickOnDialog: function () {
			if (ContentFlow.contentFlowDialog) ContentFlow.contentFlowDialog.focus();
		},

		
		// Can't use ContentFlow.Dialog2.confirm because it conflicts with the non-inline edit wizard used in the Space Configuration panel
		confirmLosingChangesSimple: function (dialog) {
			if (!ContentFlow.isDirty || confirm(ContentFlow.getText("com.brikit.contentflow.discard.workflow.edits.confirmation.unformatted"))) {
				dialog.hide();
			}
		},
		
		// Replace the Content Flow dialog's contents with the errors, pruning the option buttons down to just the cancel button
		// If no errors were found, don't mess with the Content Flow dialog
		// Return true if errors were found, false if not.
		displayAjaxResponseError: function (response, alertTitle) {
			if (response.indexOf("errorMessage") == -1) return false;
			
			var $dialog = ContentFlow.$("#content-flow-dialog");
			var $controls = $(".content-flow-controls", $dialog).remove();
			$controls.find(".aui-button:not(.cancel)").remove();
			$dialog
				.empty()
				.append("<h2>" + ContentFlow.getText("com.brikit.contentflow.error") + "</h2>")
				.append(response)
				.append($controls);
			return true;
		},

		formValueChanged: function (e) {
			ContentFlow.isDirty = true;
		},
		
		getPageId: function () {
			return typeof(pageId) == "undefined" ? ContentFlow.pageId : pageId;
		},

		hideContentFlowOptionsMenu: function () {
			$("#dropdown2-content-flow-options").remove();
		},
		
		hideWait: function () {
			ContentFlow.$("#content-flow-dialog .wait").not(".template").remove();
		},
		
		// Make a temporary highlight on element
		highlight: function (element) {
			var border = $(element).css("border");
			$(element).css("border", "3px solid #b9e5fb");
			setTimeout(function () { $(element).animate({borderWidth: 0}, 300) }, 2000);
		},

		initialize: function () {

			ContentFlow.$("#content-flow-dialog").closest(".aui-inline-dialog-contents").addClass("content-flow-dialog-contents");			

			ContentFlow.publishButtons().unbind("click").click(ContentFlow.changePublicationStep);

			if (ContentFlow.$("#manage-content-flow-form.active").length) ContentFlow.pageHasContentFlow = true;
			
			ContentFlow.$(".reviewer-entry.editor .reviewer-name")
            .find("img").removeAttr("title");

			if (ContentFlow.isCreatingNewWorkflow) {
				ContentFlow.isCreatingNewWorkflow = false;
				setTimeout(function () { $("#content-flow-new-empty-workflow-help").fadeIn("slow"); }, 1000);
			}

			ContentFlow.$(".aui-button[title], .aui-icon[title], input[title], span[title], p[title]").tooltip({aria:true});
			
			ContentFlow.$("#approval-history-expander").click(function () { 
				ContentFlow.$("#approval-history").slideToggle();
				$(".aui-icon", this).toggleClass("aui-iconfont-expanded aui-iconfont-collapsed");
			});

			ContentFlow.$("input, select").change(ContentFlow.formValueChanged);
			
			Confluence.Binder.autocompleteUserOrGroup();
			Confluence.Binder.autocompleteSpace();
			Confluence.Binder.userHover();			
			
		},
		
		isValidLabel: function (labelString) {
			// ( , !, #, &, (, ), *, ,, ., :, ;, <, >, ?, @, [, ], ^).
			return !labelString.match(/[\s!#&\(\)\*\,\.\:\;\<\>\?\@\[\]\^]/);
		},

		markAsReviewed: function () {
			
			ContentFlow.Dialog2.confirm("<p>" + ContentFlow.getText("com.brikit.contentflow.mark.page.as.reviewed") + "</p>", 
						{title: ContentFlow.getText("com.brikit.contentflow.mark.reviewed.name")}, ContentFlow.markAsReviewedWithoutAsking);

	        //return false;
	    },
		
		markAsReviewedWithoutAsking: function () {
			
	        jQuery.ajax({
	            url: ContentFlow.contextPath + "/plugins/contentflow/markasreviewed.action",
				data: {
					pageId: ContentFlow.pageId
				},
	            success: function(response) {
	                location.reload(true);
	            },
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while marking as reviewed.", errorThrown);
					// TODO: DD:  This function moved to dialogs:
					ContentFlow.refreshContentFlowHolder();
	            }
	        });

	    },
		
		publishButtons: function () {
			return ContentFlow.$("#content-flow-dialog .publish-step");
		},
		
		selectedUserName: function (field) {
			var $selected = $(field).parent().find("li.active a");
			var href = $selected.attr("href");
			if (!href) return false;
			var index = href.indexOf("/display/~");
			return index > -1 ? decodeURIComponent(href.substring(index + 10)) : false;
		},
		
		// TODO:  Move these functions to ContentFlowInlineDialog?
		showWait: function (waitSpot) {
			var $waitTemplate = ContentFlow.$("#content-flow-dialog .wait.template");
			if (waitSpot) $(waitSpot).append($waitTemplate.clone().removeClass("template").addClass("copy").show());
			else $waitTemplate.fadeIn();
		},
		

		spinStopToolbar: function () {
			var $link = ContentFlow.getPageBannerButton();
			if ($link.length) $link.find("span").spinStop();
			else ContentFlow.toolbarButton().spinStop();
		},

		toolbarButton: function () {
			// Note that this can move out of the Confluence toolbar
			return $("#content-flow-dialog-trigger");
		}		
		
	});

	ContentFlow.toInit(function ($) {
		
		$(".reviewer-entry.editor .reviewer-name").tooltip({aria:true});
		
        $("#content-flow-templates").on("click.brikit-content-flow", 	".reviewer-list .userLogoLink", 	function () { return false; })
		
		$("#user-delegate")
			.initializeExpander()
			.on("change", "#user-delegate-field", ContentFlow.changeUserDelegate)
			.on("click", ".user-delegate-field-group .aui-iconfont-remove", ContentFlow.changeUserDelegate)
			.on("keydown", "#user-delegate-field", ContentFlow.changeUserDelegatePressed);

	});
    
    ContentFlow.toFinalize(function () {
        $("#content-flow-mark-reviewed, #content-flow-archive-banner").click(ContentFlow.markAsReviewed);
    });
    
	
})(jQuery);
