/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.extractor;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.brikit.contentflow.model.PageStatus;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;

public class PageStatusExtractor
implements Extractor2 {
    public static final String PAGE_STATUS_SEARCH_FIELD_NAME = "status";
    protected ActiveObjects activeObjects;

    @Autowired
    public PageStatusExtractor(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        String status;
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (searchable instanceof AbstractPage && (status = this.getStatusName((AbstractPage)searchable)) != null) {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(PAGE_STATUS_SEARCH_FIELD_NAME, status, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
        }
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder(0);
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    protected String getStatusName(AbstractPage abstractPage) {
        PageStatus status = PageStatus.getPageStatusForPage(this.getActiveObjects(), abstractPage);
        return status == null ? "" : status.getName();
    }
}

