/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.extractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Collection;

public class DocumentIdentifierExtractor
implements Extractor2 {
    public static final String DOCUMENT_IDENTIFIER_SEARCH_FIELD_NAME = "documentId";

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        String identifier;
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (searchable instanceof Page && BrikitString.isSet((String)(identifier = this.getIdentifier((Page)searchable)))) {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(DOCUMENT_IDENTIFIER_SEARCH_FIELD_NAME, identifier, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
            String pageTitle = identifier + " " + ((Page)searchable).getTitle();
            fieldDescriptor = new FieldDescriptor("title", pageTitle, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
            String pageNumber = DocumentIdentifiers.leftPad(DocumentIdentifierSettings.getPageDocumentNumber((Page)searchable), 5, "0");
            fieldDescriptor = new FieldDescriptor("pageDocumentNumber", pageNumber, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
        }
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        if (!(searchable instanceof Page)) {
            return new StringBuilder(0);
        }
        return new StringBuilder(this.getIdentifier((Page)searchable));
    }

    protected String getIdentifier(Page page) {
        return DocumentIdentifiers.composeDocumentIdentifier((AbstractPage)page);
    }
}

