(function ($) {
	
	ContentFlow.DocumentIdentifiers = {

		dialog: function (selector) {
			var $dialog = $("#document-identifier-dialog");
			return selector ? $(selector, $dialog) : $dialog;
		},
		
		form: function (selector) {
			var $form = ContentFlow.DocumentIdentifiers.dialog("#document-identifier-form");
			return selector ? $(selector, $form) : $form;
		},
        
        handleResponse: function (response) {
            const $response = $("<div>").append(response);
            const $error = $(".errorMessage", $response);
            if ($error.length) ContentFlow.Dialog2.alert(response, {title: ContentFlow.getText("com.brikit.contentflow.error")});
            else ContentFlow.reloadBrowser();
        },
		
		initialize: function(response) {
			var options = {
				title: ContentFlow.getText("com.brikit.contentflow.set.document.identifier"),
				id: "document-identifier-dialog",
				okButton: ContentFlow.getText("com.brikit.contentflow.save.name"),
				closeWithButtonOnly: true
			};

            ContentFlow.Dialog2.dialog(response, options, ContentFlow.DocumentIdentifiers.saveDocumentIdentifier);

            $("#next-available-button").click(ContentFlow.DocumentIdentifiers.useNextAvailableIdentifier);

			ContentFlow.DocumentIdentifiers.form().submit(function () { return false} );
        },

		saveDocumentIdentifier: function (dialog) {
			ContentFlow.DocumentIdentifiers.dialog(".dialog-button-panel .button-panel-button").spin();
			
			var $form = ContentFlow.DocumentIdentifiers.form();
			$.ajax({
				url: $form.attr("action"),
				data: $form.serialize(),
				method: "POST",
				success: ContentFlow.DocumentIdentifiers.handleResponse,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while saving the document identifier.", errorThrown);
				}
			})
		},
		
		showSelector: function (event) {
			event.preventDefault();
	        jQuery.ajax({
	            url: $(this).attr("href"),
				data: {
					pageId: ContentFlow.pageId
				},
	            success: ContentFlow.DocumentIdentifiers.initialize,
	            error: function (xhRequest, textStatus, errorThrown) {
	                ContentFlow.alertError("An error occurred while loading the document identifier panel.", errorThrown);
	            }
	        });
		},
        
        useNextAvailableIdentifier: function () {
            $("#document-identifier-field").val($("#next-available-button").data("next-avail"))
        }
		
	};
	
	ContentFlow.toInit(function ($) {
		$("#content-flow-set-document-identifier").click(ContentFlow.DocumentIdentifiers.showSelector);

		// Add the document identifier to the page title, if there's a document identifier to add
		var $identifier = $(".document-identifier-metadata");
		if ($identifier.length) $("#title-heading:not(.page-title-macro) #title-text a").prepend($("<span>").addClass("document-identifier").text($identifier.text()));
	});

})(jQuery);
