/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.PageReviewFeedback;
import com.brikit.contentflow.model.UserDelegate;
import com.brikit.contentflow.model.ao.ReviewerAO;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import com.google.gson.JsonObject;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class Reviewer
extends AbstractActiveObjectsModel {
    public static final String USERNAME_KEY = "username";
    public static final String GROUPNAME_KEY = "groupname";
    protected ReviewerAO activeObject;
    protected ApprovalStep approvalStep;

    protected Reviewer(ActiveObjects activeObjects, ReviewerAO activeObject) {
        this(activeObjects, activeObject, null);
    }

    protected Reviewer(ActiveObjects activeObjects, ReviewerAO activeObject, ApprovalStep approvalStep) {
        super(activeObjects);
        this.activeObject = activeObject;
        this.approvalStep = approvalStep;
    }

    public static Reviewer create(ActiveObjects activeObjects, ApprovalStep approvalStep, int position, JsonObject reviewerJSON) throws Exception {
        ReviewerAO reviewerAO = (ReviewerAO)activeObjects.create(ReviewerAO.class, new DBParam[0]);
        reviewerAO.setApprovalStepAO(approvalStep.getActiveObject());
        Reviewer reviewer = new Reviewer(activeObjects, reviewerAO, approvalStep);
        reviewerJSON.addProperty("id", (Number)reviewer.getID());
        reviewer.setPosition(position);
        reviewer.update(reviewerJSON);
        return reviewer;
    }

    public void delete() {
        for (PageReviewFeedback pageReviewFeedback : PageReviewFeedback.getPageReviewFeedbackReferencingReviewer(this.getActiveObjects(), this)) {
            pageReviewFeedback.clearReviewerReference();
        }
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public ReviewerAO getActiveObject() {
        return this.activeObject;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public ApprovalStep getApprovalStep() {
        if (this.approvalStep == null) {
            this.approvalStep = new ApprovalStep(this.getActiveObjects(), this.getActiveObject().getApprovalStepAO());
        }
        return this.approvalStep;
    }

    public String getGroupName() {
        return this.getActiveObject().getGroupName();
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public int getPosition() {
        return this.getActiveObject().getPosition();
    }

    public ConfluenceUser getUser() {
        ConfluenceUser user = Confluence.getConfluenceUser((UserKey)this.getUserKey());
        if (user == null) {
            user = Confluence.getConfluenceUser((String)this.getUserKeyString());
        }
        return user;
    }

    protected UserKey getUserKey() {
        return BrikitString.isSet((String)this.getUserKeyString()) ? Confluence.getUserKey((String)this.getUserKeyString()) : null;
    }

    protected String getUserKeyString() {
        return this.getActiveObject().getUser();
    }

    public String getUsername() {
        ConfluenceUser user = this.getUser();
        return user == null ? null : user.getName();
    }

    public boolean isReviewer() {
        return this.isReviewer(Confluence.getConfluenceUser());
    }

    public boolean isReviewer(ConfluenceUser user) {
        return this.isReviewerByName(user) || this.isReviewerByGroup(user) || this.isReviewerByDelegate(user);
    }

    public boolean isReviewerByDelegate(ConfluenceUser user) {
        UserDelegate userDelegate = UserDelegate.getUserDelegateForDelegate(this.getActiveObjects(), user);
        if (userDelegate == null) {
            return false;
        }
        return this.isReviewerByName(userDelegate.getDelegatingUser()) || this.isReviewerByGroup(userDelegate.getDelegatingUser());
    }

    public boolean isReviewerByGroup(ConfluenceUser user) {
        return user != null && Confluence.isGroupMember((ConfluenceUser)user, (String)this.getGroupName());
    }

    public boolean isReviewerByName(ConfluenceUser user) {
        return user != null && user.equals(this.getUser());
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(ReviewerAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setGroupName(String groupName) {
        this.getActiveObject().setGroupName(groupName);
    }

    public void setPosition(int position) {
        this.getActiveObject().setPosition(position);
    }

    public void setUser(UserKey userKey) {
        this.getActiveObject().setUser(userKey == null ? null : userKey.getStringValue());
    }

    public boolean specifiesGroup() {
        return BrikitString.isSet((String)this.getGroupName());
    }

    public boolean specifiesUser() {
        return BrikitString.isSet((String)this.getUserKeyString());
    }

    public void update(JsonObject reviewerJSON) throws Exception {
        int reviewerID = reviewerJSON.get("id").getAsInt();
        if (this.getID() != reviewerID) {
            throw new Exception(Confluence.getText((String)"com.brikit.contentflow.reviewer.ids.do.not.match"));
        }
        if (reviewerJSON.has(GROUPNAME_KEY)) {
            String groupname = reviewerJSON.get(GROUPNAME_KEY).getAsString();
            this.setGroupName(groupname);
        } else {
            ConfluenceUser user = Confluence.getConfluenceUser((String)reviewerJSON.get(USERNAME_KEY).getAsString());
            UserKey userKey = Confluence.getUserKey((ConfluenceUser)user);
            this.setUser(userKey);
        }
        this.save();
    }
}

