/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchFieldNames;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.brikit.contentflow.model.ArchivePolicy;
import com.brikit.contentflow.model.ArchiveReason;
import com.brikit.contentflow.model.ArchivedPage;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.ContentOwner;
import com.brikit.contentflow.model.LastPageView;
import com.brikit.contentflow.model.PageInReview;
import com.brikit.contentflow.model.ao.PageInReviewAO;
import com.brikit.contentflow.model.query.PageInReviewQuery;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.search.CQLComposer;
import com.brikit.core.search.PagingCQLSearcher;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import net.java.ao.EntityStreamCallback;

public class Archiver {
    protected static final String ARCHIVE_KEY_TITLE_DELIMITER = ":";

    public static boolean archive(ActiveObjects activeObjects, AbstractPage abstractPage, ArchiveReason archiveReason) {
        if (abstractPage == null) {
            BrikitLog.logError((String)"No page or blogpost is available to archive.");
            return false;
        }
        if (ArchivedPage.getArchivedPageAO(activeObjects, abstractPage.getId()) != null) {
            BrikitLog.logError((String)("Archive record already exists when trying to archive " + abstractPage));
            return false;
        }
        try {
            ContentFlowConfiguration contentFlowConfiguration;
            ArchivePolicy archivePolicy;
            String archiveMessage = "Archived " + abstractPage;
            ArchivedPage archivedPage = ArchivedPage.create(activeObjects, abstractPage);
            PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, abstractPage);
            if (pageInReview != null) {
                pageInReview.delete();
            }
            if ((archivePolicy = (contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage)).getArchivePolicy()) != null && archivePolicy.isArchiveToSpace()) {
                String originalSpaceKey = Confluence.getSpaceKey((AbstractPage)abstractPage);
                Space archiveSpace = archivePolicy.getArchiveSpace();
                String spaceMarkedTitle = originalSpaceKey + ARCHIVE_KEY_TITLE_DELIMITER + Confluence.getTitle((AbstractPage)abstractPage);
                Page archiveHomePage = Confluence.getSpaceHomePage((Space)archiveSpace);
                if (archiveHomePage == null) {
                    BrikitLog.logError((String)("Can't archive page " + abstractPage + " because archiver cannot access home page for archive space " + archivePolicy.getArchiveSpaceKey()));
                    return false;
                }
                if (Confluence.isPage((AbstractPage)abstractPage)) {
                    Confluence.movePage((Page)((Page)abstractPage), (Page)Confluence.getSpaceHomePage((Space)archiveSpace));
                } else {
                    Confluence.moveBlogPost((BlogPost)((BlogPost)abstractPage), (Space)archiveSpace);
                }
                Confluence.setPageTitle((AbstractPage)abstractPage, (String)spaceMarkedTitle);
                BrikitLog.log((String)(archiveMessage + " to " + archiveSpace));
            } else {
                Confluence.trashPage((AbstractPage)abstractPage);
                BrikitLog.log((String)(archiveMessage + " to space trash"));
            }
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to archive: " + abstractPage), (Exception)ex);
            return false;
        }
        return true;
    }

    public static void archiveUnreviewedPages(final ActiveObjects activeObjects, final LocalNotificationService notificationService) {
        PageInReviewQuery query = new PageInReviewQuery(activeObjects);
        BrikitLog.log((String)"Archiving unreviewed pages...");
        final int[] count = new int[]{0};
        query.streamQuery(query.queryPageInReviews(), (EntityStreamCallback)new EntityStreamCallback<PageInReviewAO, Integer>(){

            public void onRowRead(PageInReviewAO readOnlyAO) {
                PageInReviewAO pageInReviewAO = (PageInReviewAO)activeObjects.get(PageInReviewAO.class, (Object)readOnlyAO.getID());
                PageInReview pageInReview = new PageInReview(activeObjects, pageInReviewAO);
                AbstractPage abstractPage = pageInReview.getAbstractPage();
                if (!Archiver.canArchive(activeObjects, abstractPage)) {
                    return;
                }
                Calendar reviewByDate = pageInReview.getReviewByDate();
                if (reviewByDate != null && BrikitDate.isAfter((Calendar)BrikitDate.getToday(), (Calendar)reviewByDate)) {
                    BrikitLog.log((String)("Archiving: " + pageInReview.getAbstractPage()));
                    if (Archiver.archive(activeObjects, pageInReview.getAbstractPage(), ArchiveReason.EXPIRED)) {
                        count[0] = count[0] + 1;
                        Archiver.notifyContentOwnerForArchive(activeObjects, notificationService, pageInReview.getAbstractPage());
                    }
                }
            }
        });
        BrikitLog.log((String)("Archived " + count + " unreviewed pages."));
    }

    public static boolean canArchive(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (Confluence.isPage((AbstractPage)abstractPage) && ((Page)abstractPage).hasChildren()) {
            return false;
        }
        ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forPage(activeObjects, abstractPage);
        return contentFlowConfiguration != null && contentFlowConfiguration.hasArchivePolicy() && !Archiver.isArchived(activeObjects, abstractPage);
    }

    protected static boolean flagPageForReview(ActiveObjects activeObjects, LocalNotificationService notificationService, ArchivePolicy archivePolicy, long pageId) {
        PageInReview pageInReview = PageInReview.getPageInReviewForPage(activeObjects, pageId);
        if (pageInReview == null) {
            pageInReview = PageInReview.create(activeObjects, pageId, archivePolicy);
            Archiver.notifyContentOwnerForReview(activeObjects, notificationService, Confluence.getPageOrBlogPost((long)pageId));
            BrikitLog.log((String)("Flagging for review: " + pageInReview.getAbstractPage()));
            return true;
        }
        PageInReview.addReviewLabel(activeObjects, Confluence.getPageOrBlogPost((long)pageId), archivePolicy);
        return false;
    }

    public static void flagPagesNeedingReview(ActiveObjects activeObjects, LocalNotificationService notificationService) {
        try {
            for (Space space : Confluence.getAllSpaces()) {
                int count;
                ContentFlowConfiguration contentFlowConfiguration = ContentFlowConfiguration.forSpace(activeObjects, space.getKey());
                ArchivePolicy archivePolicy = contentFlowConfiguration.getArchivePolicy();
                if (archivePolicy == null || (count = Archiver.flagPagesNeedingReviewInSpaceWithReviewPolicy(activeObjects, notificationService, space, archivePolicy)) <= 0) continue;
                BrikitLog.log((String)("Flagged " + count + " pages for review."));
            }
        }
        catch (InvalidSearchException ex) {
            BrikitLog.logError((String)"Unable to search for pages that should be flagged for review. Stopping searching.", (Exception)((Object)ex));
        }
    }

    protected static int flagPagesNeedingReviewInSpaceWithReviewPolicy(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        return archivePolicy.isReviewAfterLastView() ? Archiver.flagPagesNotViewed(activeObjects, notificationService, space, archivePolicy) : Archiver.flagPagesNotUpdated(activeObjects, notificationService, space, archivePolicy);
    }

    protected static int flagPagesNotUpdated(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        int reviewDaysAfterPublished = archivePolicy.getReviewDaysAfterPublished();
        Calendar cutoffDate = BrikitDate.addDays((Calendar)Confluence.getSystemTimeNow(), (int)(-1 * reviewDaysAfterPublished));
        CQLComposer cqlComposer = new CQLComposer();
        cqlComposer.setSpaceSearchScope(space.getKey());
        BrikitList types = new BrikitList();
        types.add((Object)"page");
        types.add((Object)"blogpost");
        cqlComposer.setContentTypes((List)types);
        cqlComposer.setLastModified("< " + BrikitDate.formatSimpleDate((Calendar)cutoffDate));
        PagingCQLSearcher cqlSearcher = new PagingCQLSearcher();
        PageResponse pageResponse = cqlSearcher.search(cqlComposer.cql(), 0, Integer.MAX_VALUE);
        int count = 0;
        for (Content result : pageResponse.getResults()) {
            if (!Archiver.flagPageForReview(activeObjects, notificationService, archivePolicy, result.getId().asLong())) continue;
            ++count;
        }
        return count;
    }

    protected static int flagPagesNotViewed(ActiveObjects activeObjects, LocalNotificationService notificationService, Space space, ArchivePolicy archivePolicy) throws InvalidSearchException {
        int days = archivePolicy.getReviewDaysAfterPublished();
        BrikitList<LastPageView> pagesNotViewed = LastPageView.getPagesNotViewedInDays(activeObjects, space.getKey(), days);
        int count = 0;
        for (LastPageView lastPageView : pagesNotViewed) {
            if (!Archiver.flagPageForReview(activeObjects, notificationService, archivePolicy, lastPageView.getPageId())) continue;
            ++count;
        }
        return count;
    }

    protected static Set<String> getFieldsToFetchForFlaggingPagesForReview() {
        Set fields = SearchFieldNames.withDefaultValues();
        fields.add("spacekey");
        fields.add("space-name");
        fields.add("title");
        fields.add("type");
        fields.add("modified");
        return fields;
    }

    public static boolean isArchived(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage != null && ArchivedPage.getArchivedPageForPage(activeObjects, abstractPage) != null;
    }

    protected static void notifyContentOwner(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage, String title, String description) {
        ConfluenceUser user;
        ContentOwner owner = ContentOwner.getContentOwner(activeObjects, abstractPage.getId());
        ConfluenceUser confluenceUser = user = owner == null ? abstractPage.getCreator() : owner.getUser();
        if (user == null) {
            BrikitLog.logWarning((String)("Unable to send review notification. No owner or creator found for page: " + abstractPage));
            return;
        }
        try {
            notificationService.createOrUpdate(user.getName(), new NotificationBuilder().application("com.brikit.contentflow").title(title).entity(abstractPage.getDisplayTitle()).itemTitle(description).description("<h2>" + Confluence.getPageLinkHTML((AbstractPage)abstractPage) + "</h2>").groupingId("com.brikit.contentflow.notification").createNotification()).get();
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Notification error sending " + title + " to user: " + user.getName() + " for page: " + abstractPage), (Exception)ex);
        }
    }

    protected static void notifyContentOwnerForArchive(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage) {
        Archiver.notifyContentOwner(activeObjects, notificationService, abstractPage, Confluence.getText((String)"com.brikit.contentflow.notification.page.archived.title", (Object[])new Object[]{abstractPage.getDisplayTitle()}), Confluence.getText((String)"com.brikit.contentflow.notification.page.archived.description"));
    }

    protected static void notifyContentOwnerForReview(ActiveObjects activeObjects, LocalNotificationService notificationService, AbstractPage abstractPage) {
        Archiver.notifyContentOwner(activeObjects, notificationService, abstractPage, Confluence.getText((String)"com.brikit.contentflow.notification.review.needed.title", (Object[])new Object[]{abstractPage.getDisplayTitle()}), Confluence.getText((String)"com.brikit.contentflow.notification.review.needed.description"));
    }

    public static void unarchiveFromArchiveSpace(ArchivedPage archivedPage) {
        AbstractPage abstractPage = archivedPage.getAbstractPage();
        try {
            BrikitList titleBits = BrikitString.splitOnFirst((String)Confluence.getTitle((AbstractPage)abstractPage), (String)ARCHIVE_KEY_TITLE_DELIMITER);
            String originalSpaceKey = titleBits.size() == 2 ? (String)titleBits.first() : Confluence.getSpaceKey((AbstractPage)abstractPage);
            String originalPageTitle = (String)titleBits.last();
            if (Confluence.isPage((AbstractPage)abstractPage)) {
                long originalParentId;
                Page currentParent = Confluence.getParent((Page)((Page)abstractPage));
                long currentParentId = currentParent == null ? 0L : currentParent.getId();
                if (currentParentId != (originalParentId = archivedPage.getOriginalParentPageId())) {
                    Page originalParent = (Page)Confluence.getPageOrBlogPost((long)originalParentId);
                    if (originalParent == null) {
                        originalParent = Confluence.getSpaceHomePage((String)originalSpaceKey);
                    }
                    Confluence.movePage((Page)((Page)abstractPage), (Page)originalParent);
                }
            } else {
                String currentSpaceKey = Confluence.getSpaceKey((AbstractPage)abstractPage);
                if (!originalSpaceKey.equals(currentSpaceKey)) {
                    Confluence.moveBlogPost((BlogPost)((BlogPost)abstractPage), (String)originalSpaceKey);
                }
            }
            if (!originalPageTitle.equals(Confluence.getTitle((AbstractPage)abstractPage))) {
                Confluence.setPageTitle((AbstractPage)abstractPage, (String)originalPageTitle);
            }
            Confluence.savePage((AbstractPage)abstractPage, (String)Confluence.getBodyAsString((ContentEntityObject)abstractPage), (String)Confluence.getText((String)"com.brikit.contentflow.page.restored.from.archive"), (boolean)false);
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to restore from archive space: " + abstractPage), (Exception)ex);
        }
    }

    public static void unarchivedFromSpaceTrash(ArchivedPage archivedPage) {
        AbstractPage abstractPage = archivedPage.getAbstractPage();
        try {
            AbstractPage originalParent = archivedPage.getOriginalParentPage();
            if (originalParent != null) {
                Confluence.movePage((Page)((Page)archivedPage.getAbstractPage()), (Page)((Page)originalParent));
            }
            archivedPage.delete();
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to restore from archive in space trash: " + abstractPage), (Exception)ex);
        }
    }
}

