/*
	NOTE
	This class is only used (and assumes) it is being used within edit-dialog.js (in an editing, not viewing, context)
*/
(function ($) {
	
	ContentFlowConfigurePanel = function (dialog) {
		this.dialog = dialog;
		this.panel = dialog.find("#configure-details");
		this.initialize();
	};
	
	Object.assign(ContentFlowConfigurePanel.prototype, {
				
		find: function(selector) {
			return selector ? $(selector, this.panel) : this.panel;
		},
		
		formValueChanged: function (e) {
			this.isDirty = true;
			this.dialog.adjustVisibility();
		},

		initialize: function () {
			var self = this;
			
			this.find("input, select").change(this.formValueChanged.bind(this));

			this.find("#workflow-routing-help").showForValue(this.find("#workflow-publishing"), "false");
			this.find("#workflow-publishing-help").showForValue(this.find("#workflow-publishing"), "true");
			this.find("#template-space-categories-field").showForValue(this.find("#workflow-visibility-option"), "SPACE_CATEGORIES");	 
			
			this.find()
                .on("click", ".workflow-labels .aui-label .aui-icon-close",	function (e) { self.workflowLabelRemove(e, this); })
                .on("selected.autocomplete-user-or-group", 	"#workflow-remove-permissions", this.removePermissionsSelected.bind(this));
		},
		
		removePermissionsSelected: function (event, data) {
			event.preventDefault();
			event.stopPropagation();

            var content = data.content;
            var isUser = content.type == "user";
            var username = isUser ? content.username : content.name;

            this.find("#workflow-remove-permissions-user").val(isUser);
            
            var $display = this.find("#workflow-remove-permissions-display").empty();

	        if (username) jQuery.ajax({
	            url: ContentFlow.contextPath + "/plugins/contentflow/renderremovepermission.action",
				data: {
					username: username,
					user: isUser
				},
	            success: function(response) {	
	                $display.append(response);
					Confluence.Binder.userHover();					
	            }.bind(this),
	            error: function (xhRequest, textStatus, errorThrown) {	
	                ContentFlow.alertError("An error occurred while looking up the user or group.", errorThrown);
	            }
	        });
		},
		
		workflowLabelRemove: function (event, target) {
			event.stopPropagation();

			var $label = $(target).closest(".aui-label");
			$label.remove();
			this.formValueChanged();
			// return false;
		},
		
		validateInput: function (showErrors) {
			var workflowName = this.find("#template-name").val();
			if (!workflowName.length) {
				if (showErrors) ContentFlow.Dialog2.alert(ContentFlow.getText("com.brikit.contentflow.template.name.required"), 
					{title: ContentFlow.getText("com.brikit.contentflow.required")}
				);
				return false;
			}
			return true;
		},
		
	});


})(jQuery);
