/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.servlet;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DocumentIdentifierFilter
extends AbstractHttpFilter {
    protected static final String SERVLET_ROOT = "/document/";
    protected FilterConfig filterConfig = null;

    public void destroy() {
    }

    protected void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Page page;
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        String path = servletRequest.getRequestURI();
        if (path.startsWith(Confluence.getContextPath())) {
            path = path.substring(Confluence.getContextPath().length());
        }
        if (!path.startsWith(SERVLET_ROOT)) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        path = path.substring(SERVLET_ROOT.length());
        String documentIdentifier = path;
        BrikitMap<String, String> libraryCodes = DocumentIdentifierSettings.getLibraryCodesByCode();
        String libraryCode = DocumentIdentifiers.libraryCodeFromDocumentIdentifier(documentIdentifier);
        String spaceKey = (String)libraryCodes.get((Object)libraryCode);
        if (BrikitString.isSet((String)spaceKey) && (page = DocumentIdentifiers.findPage(documentIdentifier, spaceKey)) != null) {
            servletResponse.sendRedirect(Confluence.getPageURL((AbstractPage)page));
            return;
        }
        filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

