/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.settings;

import com.brikit.contentflow.settings.StringSetting;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;

public abstract class AbstractStringSettingsManager {
    protected static BrikitMap<Integer, String> convertToRawMap(BrikitList<StringSetting> settings) {
        BrikitMap map = new BrikitMap();
        for (StringSetting setting : settings) {
            map.put((Object)setting.getKey(), (Object)setting.getDescription());
        }
        return map;
    }

    public synchronized Integer add(String description) {
        Integer key = this.nextAvailableKey();
        this.save(key, description);
        return key;
    }

    public void delete(Integer key) {
        BrikitMap<Integer, String> settings = this.rawMap();
        settings.remove((Object)key);
        this.save(settings);
    }

    public StringSetting getStringSetting(Integer key) {
        return (StringSetting)this.getStringSettings().get((Object)key);
    }

    public BrikitMap<Integer, StringSetting> getStringSettings() {
        BrikitMap settings = new BrikitMap();
        BrikitMap<Integer, String> map = this.rawMap();
        for (Integer key : map.sortedKeys()) {
            settings.put((Object)key, (Object)new StringSetting(key, (String)map.get((Object)key)));
        }
        return settings;
    }

    protected Integer nextAvailableKey() {
        Integer lastKey = (Integer)this.rawMap().sortedKeys().last();
        return lastKey == null ? 1 : lastKey + 1;
    }

    protected abstract BrikitMap<Integer, String> rawMap();

    public void save(Integer key, String description) {
        BrikitMap<Integer, String> settings = this.rawMap();
        settings.put((Object)key, (Object)description);
        this.save(settings);
    }

    protected void save(BrikitList<StringSetting> settings) {
        this.save(AbstractStringSettingsManager.convertToRawMap(settings));
    }

    protected abstract void save(BrikitMap<Integer, String> var1);
}

