/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.ArchiveReason;
import com.brikit.contentflow.model.Archiver;
import com.brikit.core.confluence.Confluence;
import java.util.Arrays;

public class ArchivePageAction
extends ContentFlowActionSupport {
    @Override
    public String execute() throws Exception {
        String key = this.getSpaceKey();
        String message = Confluence.getText((String)"com.brikit.contentflow.page.not.archived");
        boolean archived = Archiver.canArchive(this.getActiveObjects(), this.getPage()) && Archiver.archive(this.getActiveObjects(), this.getPage(), ArchiveReason.MANUAL);
        JSONObject json = new JSONObject();
        String pageURL = Confluence.getPageURL((long)this.getPageId());
        if (archived) {
            if (Confluence.isDeleted((AbstractPage)this.getPage())) {
                message = Confluence.getText((String)"com.brikit.contentflow.page.archived.to.space.trash");
                pageURL = Confluence.canAdministerSpace((String)key) ? Confluence.getContextPath() + "/pages/viewtrash.action?key=" + key : Confluence.getPageURL((AbstractPage)Confluence.getSpaceHomePage((String)key));
            } else {
                message = Confluence.getText((String)"com.brikit.contentflow.page.archived.to.archive.space", Arrays.asList(key));
                if (!Confluence.canRead((AbstractPage)this.getPage())) {
                    pageURL = Confluence.getPageURL((AbstractPage)Confluence.getSpaceHomePage((String)key));
                }
            }
        }
        json.put("archived", archived);
        json.put("message", (Object)message);
        json.put("pageURL", (Object)pageURL);
        return this.setJSONSuccess(json);
    }
}

