(function ($) {
	
	Object.assign(ContentFlow, {

		Workflow: function (id, name, visibility, removePermissionsName, removePermissionsUser, spaceKey, spaceCategories, publishing, entryPageStatusId, labels, exitPageStatusId) {
			this.id = id;
		    this.name = name;
			this.visibility = visibility;
            this.removePermissionsName = removePermissionsName;
            this.removePermissionsUser = removePermissionsUser;
			this.spaceKey = spaceKey;
			this.spaceCategories = spaceCategories;
			this.publishing = publishing;
            this.entryPageStatusId = entryPageStatusId;
			this.labels = labels;
            this.exitPageStatusId = exitPageStatusId;
		    this.approvalSteps = [];
		},

		ApprovalStep: function (step) {
			var self = this;
			var $step = $(step);
			
			self.id = $step.data("approval-step-id");
			self.reviewers = [];
			
			$(".reviewer-entry", $step).each(function () {
				var newReviewer = new ContentFlow.Reviewer(this);
				self.reviewers.push(newReviewer);
			});
			
			$(".approval-step-page-status", $step).each(function () {
				self.pageStatusId = $(this).data("id");
			});

			self.hasReviewer = function (userName) {
				return $(self.reviewers).filter(function () { return this.username == userName || this.groupname == username }).length;
			};
			
		},

		Reviewer: function (reviewer) {
			var $reviewer = $(reviewer);
			
			this.id = $reviewer.data("reviewer-id");
		    this.username = $reviewer.data("username");
		    this.groupname = $reviewer.data("groupname");
		}
		
	});

})(jQuery);
