/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ao.PageActivityAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import java.util.Calendar;
import java.util.Date;
import net.java.ao.Query;

public class PageActivityQuery
extends AbstractQuery {
    public PageActivityQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public int countPageActivityHistoryQuery(String spaceKey, int days) {
        return this.countQuery(this.pageActivityOlderThanQuery(spaceKey, days));
    }

    protected int countQuery(Query query) {
        return query == null ? 0 : this.getActiveObjects().count(PageActivityAO.class, query);
    }

    public PageActivityAO[] getAllPageActivityHistory(long pageId) {
        Query query = Query.select().where("PAGE_ID = ?", new Object[]{pageId});
        return this.runQuery(query);
    }

    public PageActivityAO getPageActivity(long pageId, Calendar date) {
        return this.getPageActivity(pageId, date.getTime());
    }

    public PageActivityAO getPageActivity(long pageId, Date date) {
        date = BrikitDate.dateOnly((Date)date);
        Query query = Query.select().limit(1).where("PAGE_ID = ? AND DATE = ?", new Object[]{pageId, date});
        return (PageActivityAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    public PageActivityAO[] getPageActivityHistory(long pageId, Calendar start, Calendar end) {
        return this.getPageActivityHistory(pageId, start.getTime(), end.getTime());
    }

    public PageActivityAO[] getPageActivityHistory(long pageId, Date start, Date end) {
        start = BrikitDate.dateOnly((Date)start);
        end = BrikitDate.dateOnly((Date)end);
        Query query = Query.select().where("PAGE_ID = ? AND DATE >= ? AND Date <= ?", new Object[]{pageId, start, end});
        return this.runQuery(query);
    }

    public PageActivityAO[] getPageActivityHistoryForSpace(String spaceKey, Calendar start, Calendar end) {
        return this.getPageActivityHistoryForSpace(spaceKey, start.getTime(), end.getTime());
    }

    public PageActivityAO[] getPageActivityHistoryForSpace(String spaceKey, Date start, Date end) {
        start = BrikitDate.dateOnly((Date)start);
        end = BrikitDate.dateOnly((Date)end);
        Query query = Query.select().where("SPACE_KEY = ? AND DATE >= ? AND DATE <= ?", new Object[]{spaceKey, start, end});
        return this.runQuery(query);
    }

    public PageActivityAO[] getPageActivityOlderThan(String spaceKey, int days) {
        return this.runQuery(this.pageActivityOlderThanQuery(spaceKey, days));
    }

    public PageActivityAO latestPageActivity(long pageId) {
        Query query = Query.select().limit(1).where("PAGE_ID = ? AND VIEW_COUNT > 0", new Object[]{pageId}).order("DATE DESC");
        return (PageActivityAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    protected Query pageActivityOlderThanQuery(String spaceKey, int days) {
        Calendar threshold = BrikitDate.addDays((Calendar)BrikitDate.getTodayDateOnly(), (int)(-1 * days));
        return Query.select().where("SPACE_KEY = ? AND DATE < ?", new Object[]{spaceKey, threshold.getTime()});
    }

    protected PageActivityAO[] runQuery(Query query) {
        return query == null ? new PageActivityAO[]{} : (PageActivityAO[])this.getActiveObjects().find(PageActivityAO.class, query);
    }
}

