/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.macros;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.contentflow.model.ContentOwner;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.settings.PublishDateManager;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class PageMetadataMacro
extends BrikitNoBodyMacro {
    protected static final String TEMPLATE = "content-flow/templates/macros/page-metadata.vm";
    protected static final String SHOW_PAGE_STATUS_PARAM = "show-page-status";
    protected static final String SHOW_PUBLISH_DATE_PARAM = "show-publish-date";
    protected static final String PUBLISH_DATE_FORMAT_PARAM = "publish-date-format";
    protected static final String SHOW_PAGE_OWNER_PARAM = "show-page-owner";
    protected static final String SHOW_SPACE_OWNER_PARAM = "show-space-owner";
    protected static final String SHOW_DOCUMENT_ID_PARAM = "show-document-id";
    protected static final String PUBLISH_DATE_DEFAULT_DATE_FORMAT = "MMMM dd, yyyy";
    protected static final String PAGE_STATUS = "page-status";
    protected static final String PAGE_STATUS_CLASS = "page-status-class";
    protected static final String PUBLISH_DATE = "publish-date";
    protected static final String PAGE_OWNER = "page-owner";
    protected static final String SPACE_OWNER = "space-owner";
    protected static final String DOCUMENT_ID = "document-id";
    protected ActiveObjects activeObjects;

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        PageStatus status;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.booleanValue(SHOW_PAGE_STATUS_PARAM) && (status = PageStatus.getPageStatusForPage(this.getActiveObjects(), macroContext.getPage())) != null) {
            macroContext.velocityContextAdd((Object)PAGE_STATUS, (Object)status);
            macroContext.velocityContextAdd((Object)PAGE_STATUS_CLASS, (Object)BrikitString.classify((String)status.getName()));
        }
        String dateFormat = macroContext.stringValue(PUBLISH_DATE_FORMAT_PARAM, PUBLISH_DATE_DEFAULT_DATE_FORMAT);
        if (macroContext.booleanValue(SHOW_PUBLISH_DATE_PARAM)) {
            macroContext.velocityContextAdd((Object)PUBLISH_DATE, (Object)PublishDateManager.formatPublishDate(macroContext.getPage(), dateFormat));
        }
        if (macroContext.booleanValue(SHOW_PAGE_OWNER_PARAM)) {
            macroContext.velocityContextAdd((Object)PAGE_OWNER, (Object)ContentOwner.getContentOwner(this.getActiveObjects(), macroContext.getPage().getId()));
        }
        if (macroContext.booleanValue(SHOW_SPACE_OWNER_PARAM)) {
            macroContext.velocityContextAdd((Object)SPACE_OWNER, (Object)ContentOwner.getContentOwner(this.getActiveObjects(), macroContext.getSpace().getKey()));
        }
        if (macroContext.booleanValue(SHOW_DOCUMENT_ID_PARAM)) {
            macroContext.velocityContextAdd((Object)DOCUMENT_ID, (Object)DocumentIdentifiers.composeDocumentIdentifier(macroContext.getPage()));
        }
        return this.renderTemplate(TEMPLATE, macroContext);
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }
}

