/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.extractor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.brikit.contentflow.settings.PublishDateManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

public class PublishDateExtractor
implements Extractor2 {
    public static final String PUBLISH_DATE_SEARCH_FIELD_NAME = "published";

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        String publishDate;
        ArrayList<FieldDescriptor> fieldDescriptors = new ArrayList<FieldDescriptor>();
        if (searchable instanceof AbstractPage && (publishDate = this.getPublishDate((AbstractPage)searchable)) != null) {
            FieldDescriptor fieldDescriptor = new FieldDescriptor(PUBLISH_DATE_SEARCH_FIELD_NAME, publishDate, FieldDescriptor.Store.YES, FieldDescriptor.Index.ANALYZED);
            fieldDescriptors.add(fieldDescriptor);
        }
        return fieldDescriptors;
    }

    public StringBuilder extractText(Object searchable) {
        return new StringBuilder(0);
    }

    protected String getPublishDate(AbstractPage abstractPage) {
        Calendar calendar = PublishDateManager.getPublishDate(abstractPage);
        return calendar == null ? "" : PublishDateManager.formatPublishDate(calendar);
    }
}

