/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.develop;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.core.develop.BrikitDeveloperSettingsListener;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.util.BrikitString;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExternalDevelopmentModeSettings {
    public static final String BRIKIT_DEVELOPER_KEY = "brikit.developer";
    public static final String THEMEDEV_TOGGLE_KEY = "toggle";
    public static final String EXTERNAL_LOCATION_KEY = "location";
    public static final String DISABLE_CACHES_KEY = "com.brikit.disable.caches";
    public static final String EXTERNAL_LOCATION_DEFAULT = "/repos/brikit-theme-press/src/main/resources/theme-press";
    public static final String ENABLE_THEMEDEV_ON_VALUE = "on";
    protected static List<BrikitDeveloperSettingsListener> listeners;

    protected static List<BrikitDeveloperSettingsListener> getListeners() {
        if (listeners == null) {
            listeners = new ArrayList<BrikitDeveloperSettingsListener>();
        }
        return listeners;
    }

    public static void addListener(BrikitDeveloperSettingsListener aListener) {
        ExternalDevelopmentModeSettings.getListeners().add(aListener);
    }

    public static void removeListener(BrikitDeveloperSettingsListener aListener) {
        ExternalDevelopmentModeSettings.getListeners().remove(aListener);
    }

    protected static void notifyListeners() {
        ArrayList<BrikitDeveloperSettingsListener> listenerCopy = new ArrayList<BrikitDeveloperSettingsListener>(ExternalDevelopmentModeSettings.getListeners());
        for (BrikitDeveloperSettingsListener listener : listenerCopy) {
            listener.externalDevelopmentModeSettingsChanged();
        }
    }

    public static boolean cachesEnabled() {
        String cacheSetting = (String)ExternalDevelopmentModeSettings.getBandanaManager().getValue((BandanaContext)new ConfluenceBandanaContext(), DISABLE_CACHES_KEY, false);
        return !TextUtils.stringSet((String)cacheSetting) && !ExternalDevelopmentMode.isDeveloperMode();
    }

    public static void disableCaches() {
        ExternalDevelopmentModeSettings.getBandanaManager().setValue((BandanaContext)new ConfluenceBandanaContext(), DISABLE_CACHES_KEY, (Object)ENABLE_THEMEDEV_ON_VALUE);
        ExternalDevelopmentModeSettings.notifyListeners();
    }

    public static void enableCaches() {
        ExternalDevelopmentModeSettings.getBandanaManager().setValue((BandanaContext)new ConfluenceBandanaContext(), DISABLE_CACHES_KEY, null);
        ExternalDevelopmentModeSettings.notifyListeners();
    }

    protected static BandanaManager getBandanaManager() {
        return (BandanaManager)ContainerManager.getComponent((String)"bandanaManager");
    }

    protected static String getBandanaKey() {
        return "brikit.developer:com.brikit.themepress:theme-base:";
    }

    protected static String getExternalDevelopmentKey() {
        return ExternalDevelopmentModeSettings.getBandanaKey() + THEMEDEV_TOGGLE_KEY;
    }

    protected static String getExternalLocationKey() {
        return ExternalDevelopmentModeSettings.getBandanaKey() + EXTERNAL_LOCATION_KEY;
    }

    public static String getExternalLocation() {
        String location = (String)ExternalDevelopmentModeSettings.getBandanaManager().getValue((BandanaContext)new ConfluenceBandanaContext(), ExternalDevelopmentModeSettings.getExternalLocationKey(), false);
        return BrikitString.isSet(location) ? location : EXTERNAL_LOCATION_DEFAULT;
    }

    public static File getDeveloperModePropertiesLocation() {
        return new File(ExternalDevelopmentMode.getThemeDevFolder(), "properties");
    }

    public static void setExternalLocation(String location) {
        ExternalDevelopmentModeSettings.getBandanaManager().setValue((BandanaContext)new ConfluenceBandanaContext(), ExternalDevelopmentModeSettings.getExternalLocationKey(), (Object)location);
        ExternalDevelopmentModeSettings.notifyListeners();
    }

    public static void setUseThemeDevEnv(String themeDevEnabled) {
        ExternalDevelopmentModeSettings.getBandanaManager().setValue((BandanaContext)new ConfluenceBandanaContext(), ExternalDevelopmentModeSettings.getExternalDevelopmentKey(), (Object)themeDevEnabled);
        ExternalDevelopmentModeSettings.notifyListeners();
    }

    public static String shouldUseThemeDevEnv() {
        String shouldUseThemeDev = (String)ExternalDevelopmentModeSettings.getBandanaManager().getValue((BandanaContext)new ConfluenceBandanaContext(), ExternalDevelopmentModeSettings.getExternalDevelopmentKey(), false);
        return BrikitString.trimToNull(shouldUseThemeDev);
    }
}

