/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.settings;

import com.brikit.contentflow.settings.StringSetting;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;

public abstract class AbstractStringSettingsManager {
    protected static BrikitMap<Integer, String> convertToRawMap(BrikitList<StringSetting> settings) {
        BrikitMap<Integer, String> map = new BrikitMap<Integer, String>();
        for (StringSetting setting : settings) {
            map.put(setting.getKey(), setting.getDescription());
        }
        return map;
    }

    public synchronized Integer add(String description) {
        Integer key = this.nextAvailableKey();
        this.save(key, description);
        return key;
    }

    public void delete(Integer key) {
        BrikitMap<Integer, String> settings = this.rawMap();
        settings.remove(key);
        this.save(settings);
    }

    public StringSetting getStringSetting(Integer key) {
        return (StringSetting)this.getStringSettings().get(key);
    }

    public BrikitMap<Integer, StringSetting> getStringSettings() {
        BrikitMap<Integer, StringSetting> settings = new BrikitMap<Integer, StringSetting>();
        BrikitMap<Integer, String> map = this.rawMap();
        for (Integer key : map.sortedKeys()) {
            settings.put(key, new StringSetting(key, (String)map.get(key)));
        }
        return settings;
    }

    protected Integer nextAvailableKey() {
        Integer lastKey = this.rawMap().sortedKeys().last();
        return lastKey == null ? 1 : lastKey + 1;
    }

    protected abstract BrikitMap<Integer, String> rawMap();

    public void save(Integer key, String description) {
        BrikitMap<Integer, String> settings = this.rawMap();
        settings.put(key, description);
        this.save(settings);
    }

    protected void save(BrikitList<StringSetting> settings) {
        this.save(AbstractStringSettingsManager.convertToRawMap(settings));
    }

    protected abstract void save(BrikitMap<Integer, String> var1);
}

