/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.servlet.simpledisplay.BlogPathConverter;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.brikit.comalaworkflowsservice.Comala;
import com.brikit.comalaworkflowsservice.ComalaAccessor;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import java.util.Calendar;
import java.util.StringTokenizer;

public class ComalaCompatibilityBlogPathConverter
extends BlogPathConverter {
    protected static final String CONTENT_FLOW_VIEW_PAGE_PATH = "/contentflow/pages/viewpage.action";
    protected ActiveObjects activeObjects;
    protected ComalaAccessor comalaAccessor;

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public Comala getComala() {
        return this.getComalaAccessor() == null ? null : this.getComalaAccessor().getComala();
    }

    public ComalaAccessor getComalaAccessor() {
        return this.comalaAccessor;
    }

    public ConvertedPath getPath(String path, String queryString) {
        DisplayPath displayPath = new DisplayPath(path);
        ConvertedPath convertedPath = new ConvertedPath(CONTENT_FLOW_VIEW_PAGE_PATH);
        convertedPath.addParameter("spaceKey", displayPath.getSpaceKey());
        String postingDate = displayPath.getYear() + "/" + displayPath.getMonth() + "/" + displayPath.getDay();
        convertedPath.addParameter("postingDay", postingDate);
        convertedPath.addParameter("title", displayPath.getPageTitle());
        return convertedPath;
    }

    public boolean handles(String path, String queryString) {
        if (!this.isComalaInstalled()) {
            return false;
        }
        if (new StringTokenizer(path, "/").countTokens() != 5) {
            return false;
        }
        DisplayPath displayPath = new DisplayPath(path);
        return ContentFlowConfiguration.canUseWorkflows(this.getActiveObjects(), displayPath.getSpaceKey());
    }

    public boolean isComalaInstalled() {
        return this.getComala() != null;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void setComalaAccessor(ComalaAccessor comalaAccessor) {
        this.comalaAccessor = comalaAccessor;
    }

    protected class DisplayPath {
        protected String spaceKey;
        protected int year;
        protected int month;
        protected int day;
        protected String pageTitle;

        public DisplayPath(String path) {
            StringTokenizer st = new StringTokenizer(path, "/");
            this.setSpaceKey(st.nextToken());
            this.setYear(st.nextToken());
            this.setMonth(st.nextToken());
            this.setDay(st.nextToken());
            this.setPageTitle(st.nextToken());
        }

        public int getDay() {
            return this.day;
        }

        public int getMonth() {
            return this.month;
        }

        public BlogPost getPage() {
            try {
                Calendar calendar = BrikitDate.getCalendar(this.getYear(), this.getMonth(), this.getDay());
                return Confluence.getBlogPost(this.getSpaceKey(), this.getPageTitle(), calendar);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getSpaceKey() {
            return this.spaceKey;
        }

        public int getYear() {
            return this.year;
        }

        public boolean pageFound() {
            return this.getPage() != null;
        }

        public int parseInt(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }

        public void setDay(String day) {
            this.day = this.parseInt(day);
        }

        public void setMonth(String month) {
            this.month = this.parseInt(month);
        }

        public void setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        public void setSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
        }

        public void setYear(String year) {
            this.year = this.parseInt(year);
        }
    }
}

