/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ao.LastPageViewAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import java.util.Calendar;
import net.java.ao.Query;

public class LastPageViewQuery
extends AbstractQuery {
    public LastPageViewQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public LastPageViewAO getLastPageView(long pageId) {
        Query query = Query.select().limit(1).where("PAGE_ID = ?", new Object[]{pageId});
        return new BrikitList<LastPageViewAO>(this.runQuery(query)).first();
    }

    public LastPageViewAO[] getPagesNotViewedInDays(String spaceKey, int days) {
        Calendar date = BrikitDate.addDays(BrikitDate.getTodayDateOnly(), -1 * days);
        Query query = Query.select().where("SPACE_KEY = ? AND DATE < ?", new Object[]{spaceKey, date.getTime()}).order("DATE");
        return this.runQuery(query);
    }

    protected LastPageViewAO[] runQuery(Query query) {
        return query == null ? new LastPageViewAO[]{} : (LastPageViewAO[])this.getActiveObjects().find(LastPageViewAO.class, query);
    }
}

