/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ao.ArchivedPageAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitList;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;

public class ArchivedPageQuery
extends AbstractQuery {
    public ArchivedPageQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public ArchivedPageAO getArchivedPageForPage(long pageId) {
        Query query = Query.select().where("PAGE_ID = ?", new Object[]{pageId});
        return new BrikitList<ArchivedPageAO>(this.runQuery(query)).first();
    }

    public ArchivedPageAO[] getArchivedPages(String spaceKey) {
        Query query = Query.select().where("ORIGINAL_SPACE_KEY = ?", new Object[]{spaceKey});
        return this.runQuery(query);
    }

    public ArchivedPageAO[] getArchivedPagesFlaggedForReview(String spaceKey) {
        Query query = Query.select().where("DATE_TO_ARCHIVE_IF_NO_REVIEW IS NOT NULL and PAGE_ID > 0 and SPACE_KEY = ? and DATE_ARCHIVED IS NULL", new Object[]{spaceKey});
        return this.runQuery(query);
    }

    public ArchivedPageAO[] getArchivedPagesThatNeedArchiving() {
        Query query = Query.select().where("ARCHIVE_ON_DATE <= ? and DATE_ARCHIVED IS NULL", new Object[]{this.getNow()});
        return this.runQuery(query);
    }

    public ArchivedPageAO[] getWorkflowsForPagesScheduledForArchiving() {
        Query query = Query.select().where("ARCHIVE_ON_DATE <= ? and DATE_ARCHIVED IS NULL", new Object[]{this.getNow()});
        return this.runQuery(query);
    }

    protected ArchivedPageAO[] runQuery(Query query) {
        return query == null ? new ArchivedPageAO[]{} : (ArchivedPageAO[])this.getActiveObjects().find(ArchivedPageAO.class, query);
    }

    public void streamQuery(Query query, EntityStreamCallback callback) {
        this.getActiveObjects().stream(ArchivedPageAO.class, query, callback);
    }
}

