/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.ao.upgrade.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.brikit.contentflow.model.ao.ApprovalStepAO;
import com.brikit.contentflow.model.ao.PageStatusAO;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class PageStatusUpgradeTask
implements ActiveObjectsUpgradeTask {
    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        ao.migrate(new Class[]{ApprovalStepAO.class});
        ao.migrate(new Class[]{PageStatusAO.class});
        BrikitLog.log("Begin: upgrade labels to statuses in approval steps...");
        for (ApprovalStepAO approvalStepAO : (ApprovalStepAO[])ao.find(ApprovalStepAO.class)) {
            PageStatusAO pageStatusAO;
            BrikitList<String> labels = BrikitString.splitCommaSeparated(approvalStepAO.getLabels());
            String label = labels.first();
            if (!BrikitString.isSet(label)) continue;
            Query query = Query.select().limit(1).where("LABEL = ?", new Object[]{label});
            PageStatusAO[] pageStatusAOs = (PageStatusAO[])ao.find(PageStatusAO.class, query);
            if (pageStatusAOs.length == 0) {
                String statusName = BrikitString.titleize(BrikitString.humanize(label));
                BrikitLog.log("Create status: " + statusName + " for label: " + label);
                PageStatusAO pageStatusAO2 = (PageStatusAO)ao.create(PageStatusAO.class, new DBParam[0]);
                pageStatusAO2.setName(statusName);
                pageStatusAO2.setLabel(label);
                pageStatusAO2.save();
            }
            if ((pageStatusAO = new BrikitList<PageStatusAO>(pageStatusAOs = (PageStatusAO[])ao.find(PageStatusAO.class, query)).first()) == null) {
                BrikitLog.logError("Couldn't find page status for label: " + label + " after creating it. This affects approval step id: " + approvalStepAO.getID());
                continue;
            }
            BrikitLog.log("Updating approval step: " + approvalStepAO.getID() + " with page status: " + pageStatusAO.getName());
            approvalStepAO.setPageStatusAO(pageStatusAO);
            approvalStepAO.save();
        }
        BrikitLog.log("Complete: upgrade labels to statuses in approval steps.");
    }
}

